/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.Entity;

@SdkInternalApi
public class EntityMarshaller {
    private static final MarshallingInfo<String> ENTITYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityType").build();
    private static final MarshallingInfo<String> ENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityId").build();
    private static final EntityMarshaller instance = new EntityMarshaller();

    public static EntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Entity entity, ProtocolMarshaller protocolMarshaller) {
        if (entity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)entity.getEntityType(), ENTITYTYPE_BINDING);
            protocolMarshaller.marshall((Object)entity.getEntityId(), ENTITYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

