/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.FileSystemFailureDetails;
import com.amazonaws.services.fsx.model.FileSystemLifecycle;
import com.amazonaws.services.fsx.model.FileSystemType;
import com.amazonaws.services.fsx.model.LustreFileSystemConfiguration;
import com.amazonaws.services.fsx.model.Tag;
import com.amazonaws.services.fsx.model.WindowsFileSystemConfiguration;
import com.amazonaws.services.fsx.model.transform.FileSystemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FileSystem
implements Serializable,
Cloneable,
StructuredPojo {
    private String ownerId;
    private Date creationTime;
    private String fileSystemId;
    private String fileSystemType;
    private String lifecycle;
    private FileSystemFailureDetails failureDetails;
    private Integer storageCapacity;
    private String vpcId;
    private List<String> subnetIds;
    private List<String> networkInterfaceIds;
    private String dNSName;
    private String kmsKeyId;
    private String resourceARN;
    private List<Tag> tags;
    private WindowsFileSystemConfiguration windowsConfiguration;
    private LustreFileSystemConfiguration lustreConfiguration;

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public FileSystem withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public FileSystem withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public FileSystem withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public void setFileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public FileSystem withFileSystemType(String fileSystemType) {
        this.setFileSystemType(fileSystemType);
        return this;
    }

    public FileSystem withFileSystemType(FileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType.toString();
        return this;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public FileSystem withLifecycle(String lifecycle) {
        this.setLifecycle(lifecycle);
        return this;
    }

    public FileSystem withLifecycle(FileSystemLifecycle lifecycle) {
        this.lifecycle = lifecycle.toString();
        return this;
    }

    public void setFailureDetails(FileSystemFailureDetails failureDetails) {
        this.failureDetails = failureDetails;
    }

    public FileSystemFailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    public FileSystem withFailureDetails(FileSystemFailureDetails failureDetails) {
        this.setFailureDetails(failureDetails);
        return this;
    }

    public void setStorageCapacity(Integer storageCapacity) {
        this.storageCapacity = storageCapacity;
    }

    public Integer getStorageCapacity() {
        return this.storageCapacity;
    }

    public FileSystem withStorageCapacity(Integer storageCapacity) {
        this.setStorageCapacity(storageCapacity);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public FileSystem withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public FileSystem withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public FileSystem withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<String> getNetworkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        if (networkInterfaceIds == null) {
            this.networkInterfaceIds = null;
            return;
        }
        this.networkInterfaceIds = new ArrayList<String>(networkInterfaceIds);
    }

    public FileSystem withNetworkInterfaceIds(String ... networkInterfaceIds) {
        if (this.networkInterfaceIds == null) {
            this.setNetworkInterfaceIds(new ArrayList<String>(networkInterfaceIds.length));
        }
        for (String ele : networkInterfaceIds) {
            this.networkInterfaceIds.add(ele);
        }
        return this;
    }

    public FileSystem withNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        this.setNetworkInterfaceIds(networkInterfaceIds);
        return this;
    }

    public void setDNSName(String dNSName) {
        this.dNSName = dNSName;
    }

    public String getDNSName() {
        return this.dNSName;
    }

    public FileSystem withDNSName(String dNSName) {
        this.setDNSName(dNSName);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public FileSystem withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public FileSystem withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public FileSystem withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public FileSystem withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setWindowsConfiguration(WindowsFileSystemConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
    }

    public WindowsFileSystemConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    public FileSystem withWindowsConfiguration(WindowsFileSystemConfiguration windowsConfiguration) {
        this.setWindowsConfiguration(windowsConfiguration);
        return this;
    }

    public void setLustreConfiguration(LustreFileSystemConfiguration lustreConfiguration) {
        this.lustreConfiguration = lustreConfiguration;
    }

    public LustreFileSystemConfiguration getLustreConfiguration() {
        return this.lustreConfiguration;
    }

    public FileSystem withLustreConfiguration(LustreFileSystemConfiguration lustreConfiguration) {
        this.setLustreConfiguration(lustreConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getFileSystemType() != null) {
            sb.append("FileSystemType: ").append(this.getFileSystemType()).append(",");
        }
        if (this.getLifecycle() != null) {
            sb.append("Lifecycle: ").append(this.getLifecycle()).append(",");
        }
        if (this.getFailureDetails() != null) {
            sb.append("FailureDetails: ").append(this.getFailureDetails()).append(",");
        }
        if (this.getStorageCapacity() != null) {
            sb.append("StorageCapacity: ").append(this.getStorageCapacity()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getNetworkInterfaceIds() != null) {
            sb.append("NetworkInterfaceIds: ").append(this.getNetworkInterfaceIds()).append(",");
        }
        if (this.getDNSName() != null) {
            sb.append("DNSName: ").append(this.getDNSName()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWindowsConfiguration() != null) {
            sb.append("WindowsConfiguration: ").append(this.getWindowsConfiguration()).append(",");
        }
        if (this.getLustreConfiguration() != null) {
            sb.append("LustreConfiguration: ").append(this.getLustreConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystem)) {
            return false;
        }
        FileSystem other = (FileSystem)obj;
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getFileSystemType() == null ^ this.getFileSystemType() == null) {
            return false;
        }
        if (other.getFileSystemType() != null && !other.getFileSystemType().equals(this.getFileSystemType())) {
            return false;
        }
        if (other.getLifecycle() == null ^ this.getLifecycle() == null) {
            return false;
        }
        if (other.getLifecycle() != null && !other.getLifecycle().equals(this.getLifecycle())) {
            return false;
        }
        if (other.getFailureDetails() == null ^ this.getFailureDetails() == null) {
            return false;
        }
        if (other.getFailureDetails() != null && !other.getFailureDetails().equals(this.getFailureDetails())) {
            return false;
        }
        if (other.getStorageCapacity() == null ^ this.getStorageCapacity() == null) {
            return false;
        }
        if (other.getStorageCapacity() != null && !other.getStorageCapacity().equals(this.getStorageCapacity())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getNetworkInterfaceIds() == null ^ this.getNetworkInterfaceIds() == null) {
            return false;
        }
        if (other.getNetworkInterfaceIds() != null && !other.getNetworkInterfaceIds().equals(this.getNetworkInterfaceIds())) {
            return false;
        }
        if (other.getDNSName() == null ^ this.getDNSName() == null) {
            return false;
        }
        if (other.getDNSName() != null && !other.getDNSName().equals(this.getDNSName())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWindowsConfiguration() == null ^ this.getWindowsConfiguration() == null) {
            return false;
        }
        if (other.getWindowsConfiguration() != null && !other.getWindowsConfiguration().equals(this.getWindowsConfiguration())) {
            return false;
        }
        if (other.getLustreConfiguration() == null ^ this.getLustreConfiguration() == null) {
            return false;
        }
        return other.getLustreConfiguration() == null || other.getLustreConfiguration().equals(this.getLustreConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemType() == null ? 0 : this.getFileSystemType().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycle() == null ? 0 : this.getLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getFailureDetails() == null ? 0 : this.getFailureDetails().hashCode());
        hashCode = 31 * hashCode + (this.getStorageCapacity() == null ? 0 : this.getStorageCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaceIds() == null ? 0 : this.getNetworkInterfaceIds().hashCode());
        hashCode = 31 * hashCode + (this.getDNSName() == null ? 0 : this.getDNSName().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWindowsConfiguration() == null ? 0 : this.getWindowsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLustreConfiguration() == null ? 0 : this.getLustreConfiguration().hashCode());
        return hashCode;
    }

    public FileSystem clone() {
        try {
            return (FileSystem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSystemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

