/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamesparks.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamesparks.model.GameSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGamesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<GameSummary> games;
    private String nextToken;

    public List<GameSummary> getGames() {
        return this.games;
    }

    public void setGames(Collection<GameSummary> games) {
        if (games == null) {
            this.games = null;
            return;
        }
        this.games = new ArrayList<GameSummary>(games);
    }

    public ListGamesResult withGames(GameSummary ... games) {
        if (this.games == null) {
            this.setGames(new ArrayList<GameSummary>(games.length));
        }
        for (GameSummary ele : games) {
            this.games.add(ele);
        }
        return this;
    }

    public ListGamesResult withGames(Collection<GameSummary> games) {
        this.setGames(games);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListGamesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGames() != null) {
            sb.append("Games: ").append(this.getGames()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGamesResult)) {
            return false;
        }
        ListGamesResult other = (ListGamesResult)obj;
        if (other.getGames() == null ^ this.getGames() == null) {
            return false;
        }
        if (other.getGames() != null && !other.getGames().equals(this.getGames())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGames() == null ? 0 : this.getGames().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListGamesResult clone() {
        try {
            return (ListGamesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

