/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.util;

import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IntermediateModelRetriever {
    public static List<IntermediateModel> getDependencyIntermediateModels() throws IOException {
        ArrayList<IntermediateModel> intermediateModels = new ArrayList<IntermediateModel>();
        Enumeration<URL> en = IntermediateModelRetriever.class.getClassLoader().getResources("META-INF");
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            JarURLConnection urlcon = (JarURLConnection)url.openConnection();
            JarFile jar = urlcon.getJarFile();
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("-intermediate.json")) continue;
                    intermediateModels.add(IntermediateModelRetriever.deserializeIntermediateModel(jar.getInputStream(entry)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jar == null) continue;
                if (throwable != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jar.close();
            }
        }
        return intermediateModels;
    }

    public static IntermediateModel deserializeIntermediateModel(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (IntermediateModel)mapper.readValue(in, IntermediateModel.class);
    }
}

