/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteVaultNotificationsRequestMarshaller
implements Marshaller<Request<DeleteVaultNotificationsRequest>, DeleteVaultNotificationsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteVaultNotificationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteVaultNotificationsRequest> marshall(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        if (deleteVaultNotificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteVaultNotificationsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/notification-configuration";
        uriResourcePath = uriResourcePath.replace("{accountId}", deleteVaultNotificationsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteVaultNotificationsRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", deleteVaultNotificationsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteVaultNotificationsRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

