/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.PortMapping;
import java.util.List;

@SdkInternalApi
public class PortMappingMarshaller {
    private static final MarshallingInfo<Integer> ACCELERATORPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceleratorPort").build();
    private static final MarshallingInfo<String> ENDPOINTGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointGroupArn").build();
    private static final MarshallingInfo<String> ENDPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointId").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSOCKETADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSocketAddress").build();
    private static final MarshallingInfo<List> PROTOCOLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocols").build();
    private static final MarshallingInfo<String> DESTINATIONTRAFFICSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationTrafficState").build();
    private static final PortMappingMarshaller instance = new PortMappingMarshaller();

    public static PortMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(PortMapping portMapping, ProtocolMarshaller protocolMarshaller) {
        if (portMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)portMapping.getAcceleratorPort(), ACCELERATORPORT_BINDING);
            protocolMarshaller.marshall((Object)portMapping.getEndpointGroupArn(), ENDPOINTGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)portMapping.getEndpointId(), ENDPOINTID_BINDING);
            protocolMarshaller.marshall((Object)portMapping.getDestinationSocketAddress(), DESTINATIONSOCKETADDRESS_BINDING);
            protocolMarshaller.marshall(portMapping.getProtocols(), PROTOCOLS_BINDING);
            protocolMarshaller.marshall((Object)portMapping.getDestinationTrafficState(), DESTINATIONTRAFFICSTATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

