/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.Workflow;
import com.amazonaws.services.glue.model.transform.WorkflowGraphJsonUnmarshaller;
import com.amazonaws.services.glue.model.transform.WorkflowRunJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class WorkflowJsonUnmarshaller
implements Unmarshaller<Workflow, JsonUnmarshallerContext> {
    private static WorkflowJsonUnmarshaller instance;

    public Workflow unmarshall(JsonUnmarshallerContext context) throws Exception {
        Workflow workflow = new Workflow();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    workflow.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    workflow.setDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultRunProperties", targetDepth)) {
                    context.nextToken();
                    workflow.setDefaultRunProperties(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedOn", targetDepth)) {
                    context.nextToken();
                    workflow.setCreatedOn(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastModifiedOn", targetDepth)) {
                    context.nextToken();
                    workflow.setLastModifiedOn(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastRun", targetDepth)) {
                    context.nextToken();
                    workflow.setLastRun(WorkflowRunJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Graph", targetDepth)) {
                    context.nextToken();
                    workflow.setGraph(WorkflowGraphJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return workflow;
    }

    public static WorkflowJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new WorkflowJsonUnmarshaller();
        }
        return instance;
    }
}

