/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Workflow;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class WorkflowMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Map> DEFAULTRUNPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRunProperties").build();
    private static final MarshallingInfo<Date> CREATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LASTRUN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRun").build();
    private static final MarshallingInfo<StructuredPojo> GRAPH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Graph").build();
    private static final MarshallingInfo<Integer> MAXCONCURRENTRUNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrentRuns").build();
    private static final WorkflowMarshaller instance = new WorkflowMarshaller();

    public static WorkflowMarshaller getInstance() {
        return instance;
    }

    public void marshall(Workflow workflow, ProtocolMarshaller protocolMarshaller) {
        if (workflow == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workflow.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)workflow.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(workflow.getDefaultRunProperties(), DEFAULTRUNPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)workflow.getCreatedOn(), CREATEDON_BINDING);
            protocolMarshaller.marshall((Object)workflow.getLastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall((Object)workflow.getLastRun(), LASTRUN_BINDING);
            protocolMarshaller.marshall((Object)workflow.getGraph(), GRAPH_BINDING);
            protocolMarshaller.marshall((Object)workflow.getMaxConcurrentRuns(), MAXCONCURRENTRUNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

