/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetUnfilteredPartitionsMetadataRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account ID is
     * used by default.
     * </p>
     */
    private String catalogId;
    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     */
    private String databaseName;
    /**
     * <p>
     * The name of the table that contains the partition.
     * </p>
     */
    private String tableName;
    /**
     * <p>
     * An expression that filters the partitions to be returned.
     * </p>
     * <p>
     * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a
     * href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     * </p>
     * <p>
     * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
     * </p>
     * <dl>
     * <dt>=</dt>
     * <dd>
     * <p>
     * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     * </p>
     * <p>
     * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     * </p>
     * <p>
     * (a = b) is not true.
     * </p>
     * </dd>
     * <dt>&lt; &gt;</dt>
     * <dd>
     * <p>
     * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
     * true.
     * </p>
     * <p>
     * Example: (a &lt; &gt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt; b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt;= b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt;= b) is true.
     * </p>
     * </dd>
     * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     * <dd>
     * <p>
     * Logical operators.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>date</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>int</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bigint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>long</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tinyint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>smallint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>decimal</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If an type is encountered that is not valid, an exception is thrown.
     * </p>
     */
    private String expression;
    /**
     * <p>
     * A structure containing Lake Formation audit context information.
     * </p>
     */
    private AuditContext auditContext;
    /**
     * <p>
     * A list of supported permission types.
     * </p>
     */
    private java.util.List<String> supportedPermissionTypes;
    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these partitions.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The segment of the table's partitions to scan in this request.
     * </p>
     */
    private Segment segment;
    /**
     * <p>
     * The maximum number of partitions to return in a single response.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account ID is
     * used by default.
     * </p>
     * 
     * @param catalogId
     *        The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account
     *        ID is used by default.
     */

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account
     *         ID is used by default.
     */

    public String getCatalogId() {
        return this.catalogId;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account ID is
     * used by default.
     * </p>
     * 
     * @param catalogId
     *        The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account
     *        ID is used by default.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withCatalogId(String catalogId) {
        setCatalogId(catalogId);
        return this;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @param databaseName
     *        The name of the catalog database where the partitions reside.
     */

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @return The name of the catalog database where the partitions reside.
     */

    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @param databaseName
     *        The name of the catalog database where the partitions reside.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withDatabaseName(String databaseName) {
        setDatabaseName(databaseName);
        return this;
    }

    /**
     * <p>
     * The name of the table that contains the partition.
     * </p>
     * 
     * @param tableName
     *        The name of the table that contains the partition.
     */

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * <p>
     * The name of the table that contains the partition.
     * </p>
     * 
     * @return The name of the table that contains the partition.
     */

    public String getTableName() {
        return this.tableName;
    }

    /**
     * <p>
     * The name of the table that contains the partition.
     * </p>
     * 
     * @param tableName
     *        The name of the table that contains the partition.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withTableName(String tableName) {
        setTableName(tableName);
        return this;
    }

    /**
     * <p>
     * An expression that filters the partitions to be returned.
     * </p>
     * <p>
     * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a
     * href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     * </p>
     * <p>
     * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
     * </p>
     * <dl>
     * <dt>=</dt>
     * <dd>
     * <p>
     * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     * </p>
     * <p>
     * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     * </p>
     * <p>
     * (a = b) is not true.
     * </p>
     * </dd>
     * <dt>&lt; &gt;</dt>
     * <dd>
     * <p>
     * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
     * true.
     * </p>
     * <p>
     * Example: (a &lt; &gt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt; b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt;= b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt;= b) is true.
     * </p>
     * </dd>
     * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     * <dd>
     * <p>
     * Logical operators.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>date</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>int</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bigint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>long</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tinyint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>smallint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>decimal</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If an type is encountered that is not valid, an exception is thrown.
     * </p>
     * 
     * @param expression
     *        An expression that filters the partitions to be returned.</p>
     *        <p>
     *        The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement
     *        parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     *        </p>
     *        <p>
     *        <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API
     *        call:
     *        </p>
     *        <dl>
     *        <dt>=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     *        </p>
     *        <p>
     *        (a = b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt; &gt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the values of two operands are equal; if the values are not equal, then the condition
     *        becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt; &gt; b) is true.
     *        </p>
     *        </dd>
     *        <dt>&gt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is greater than the value of the right operand; if yes, then
     *        the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &gt; b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     *        condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt; b) is true.
     *        </p>
     *        </dd>
     *        <dt>&gt;=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is greater than or equal to the value of the right operand;
     *        if yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &gt;= b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt;=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is less than or equal to the value of the right operand; if
     *        yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt;= b) is true.
     *        </p>
     *        </dd>
     *        <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     *        <dd>
     *        <p>
     *        Logical operators.
     *        </p>
     *        </dd>
     *        </dl>
     *        <p>
     *        <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>string</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>date</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>timestamp</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>int</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>bigint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>long</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>tinyint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>smallint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>decimal</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If an type is encountered that is not valid, an exception is thrown.
     */

    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * <p>
     * An expression that filters the partitions to be returned.
     * </p>
     * <p>
     * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a
     * href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     * </p>
     * <p>
     * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
     * </p>
     * <dl>
     * <dt>=</dt>
     * <dd>
     * <p>
     * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     * </p>
     * <p>
     * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     * </p>
     * <p>
     * (a = b) is not true.
     * </p>
     * </dd>
     * <dt>&lt; &gt;</dt>
     * <dd>
     * <p>
     * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
     * true.
     * </p>
     * <p>
     * Example: (a &lt; &gt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt; b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt;= b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt;= b) is true.
     * </p>
     * </dd>
     * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     * <dd>
     * <p>
     * Logical operators.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>date</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>int</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bigint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>long</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tinyint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>smallint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>decimal</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If an type is encountered that is not valid, an exception is thrown.
     * </p>
     * 
     * @return An expression that filters the partitions to be returned.</p>
     *         <p>
     *         The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement
     *         parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     *         </p>
     *         <p>
     *         <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API
     *         call:
     *         </p>
     *         <dl>
     *         <dt>=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     *         </p>
     *         <p>
     *         (a = b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt; &gt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the values of two operands are equal; if the values are not equal, then the condition
     *         becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt; &gt; b) is true.
     *         </p>
     *         </dd>
     *         <dt>&gt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is greater than the value of the right operand; if yes, then
     *         the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &gt; b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt;</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is less than the value of the right operand; if yes, then
     *         the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt; b) is true.
     *         </p>
     *         </dd>
     *         <dt>&gt;=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is greater than or equal to the value of the right operand;
     *         if yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &gt;= b) is not true.
     *         </p>
     *         </dd>
     *         <dt>&lt;=</dt>
     *         <dd>
     *         <p>
     *         Checks whether the value of the left operand is less than or equal to the value of the right operand; if
     *         yes, then the condition becomes true.
     *         </p>
     *         <p>
     *         Example: (a &lt;= b) is true.
     *         </p>
     *         </dd>
     *         <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     *         <dd>
     *         <p>
     *         Logical operators.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>string</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>date</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>timestamp</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>int</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bigint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>long</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tinyint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>smallint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>decimal</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If an type is encountered that is not valid, an exception is thrown.
     */

    public String getExpression() {
        return this.expression;
    }

    /**
     * <p>
     * An expression that filters the partitions to be returned.
     * </p>
     * <p>
     * The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a
     * href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     * </p>
     * <p>
     * <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:
     * </p>
     * <dl>
     * <dt>=</dt>
     * <dd>
     * <p>
     * Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     * </p>
     * <p>
     * Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     * </p>
     * <p>
     * (a = b) is not true.
     * </p>
     * </dd>
     * <dt>&lt; &gt;</dt>
     * <dd>
     * <p>
     * Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes
     * true.
     * </p>
     * <p>
     * Example: (a &lt; &gt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt; b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     * condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt; b) is true.
     * </p>
     * </dd>
     * <dt>&gt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &gt;= b) is not true.
     * </p>
     * </dd>
     * <dt>&lt;=</dt>
     * <dd>
     * <p>
     * Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes,
     * then the condition becomes true.
     * </p>
     * <p>
     * Example: (a &lt;= b) is true.
     * </p>
     * </dd>
     * <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     * <dd>
     * <p>
     * Logical operators.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>date</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>int</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bigint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>long</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tinyint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>smallint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>decimal</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If an type is encountered that is not valid, an exception is thrown.
     * </p>
     * 
     * @param expression
     *        An expression that filters the partitions to be returned.</p>
     *        <p>
     *        The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement
     *        parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression.
     *        </p>
     *        <p>
     *        <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API
     *        call:
     *        </p>
     *        <dl>
     *        <dt>=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the values of the two operands are equal; if yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
     *        </p>
     *        <p>
     *        (a = b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt; &gt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the values of two operands are equal; if the values are not equal, then the condition
     *        becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt; &gt; b) is true.
     *        </p>
     *        </dd>
     *        <dt>&gt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is greater than the value of the right operand; if yes, then
     *        the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &gt; b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt;</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is less than the value of the right operand; if yes, then the
     *        condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt; b) is true.
     *        </p>
     *        </dd>
     *        <dt>&gt;=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is greater than or equal to the value of the right operand;
     *        if yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &gt;= b) is not true.
     *        </p>
     *        </dd>
     *        <dt>&lt;=</dt>
     *        <dd>
     *        <p>
     *        Checks whether the value of the left operand is less than or equal to the value of the right operand; if
     *        yes, then the condition becomes true.
     *        </p>
     *        <p>
     *        Example: (a &lt;= b) is true.
     *        </p>
     *        </dd>
     *        <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
     *        <dd>
     *        <p>
     *        Logical operators.
     *        </p>
     *        </dd>
     *        </dl>
     *        <p>
     *        <i>Supported Partition Key Types</i>: The following are the supported partition keys.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>string</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>date</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>timestamp</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>int</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>bigint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>long</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>tinyint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>smallint</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>decimal</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If an type is encountered that is not valid, an exception is thrown.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withExpression(String expression) {
        setExpression(expression);
        return this;
    }

    /**
     * <p>
     * A structure containing Lake Formation audit context information.
     * </p>
     * 
     * @param auditContext
     *        A structure containing Lake Formation audit context information.
     */

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    /**
     * <p>
     * A structure containing Lake Formation audit context information.
     * </p>
     * 
     * @return A structure containing Lake Formation audit context information.
     */

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    /**
     * <p>
     * A structure containing Lake Formation audit context information.
     * </p>
     * 
     * @param auditContext
     *        A structure containing Lake Formation audit context information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withAuditContext(AuditContext auditContext) {
        setAuditContext(auditContext);
        return this;
    }

    /**
     * <p>
     * A list of supported permission types.
     * </p>
     * 
     * @return A list of supported permission types.
     * @see PermissionType
     */

    public java.util.List<String> getSupportedPermissionTypes() {
        return supportedPermissionTypes;
    }

    /**
     * <p>
     * A list of supported permission types.
     * </p>
     * 
     * @param supportedPermissionTypes
     *        A list of supported permission types.
     * @see PermissionType
     */

    public void setSupportedPermissionTypes(java.util.Collection<String> supportedPermissionTypes) {
        if (supportedPermissionTypes == null) {
            this.supportedPermissionTypes = null;
            return;
        }

        this.supportedPermissionTypes = new java.util.ArrayList<String>(supportedPermissionTypes);
    }

    /**
     * <p>
     * A list of supported permission types.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSupportedPermissionTypes(java.util.Collection)} or
     * {@link #withSupportedPermissionTypes(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param supportedPermissionTypes
     *        A list of supported permission types.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PermissionType
     */

    public GetUnfilteredPartitionsMetadataRequest withSupportedPermissionTypes(String... supportedPermissionTypes) {
        if (this.supportedPermissionTypes == null) {
            setSupportedPermissionTypes(new java.util.ArrayList<String>(supportedPermissionTypes.length));
        }
        for (String ele : supportedPermissionTypes) {
            this.supportedPermissionTypes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of supported permission types.
     * </p>
     * 
     * @param supportedPermissionTypes
     *        A list of supported permission types.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PermissionType
     */

    public GetUnfilteredPartitionsMetadataRequest withSupportedPermissionTypes(java.util.Collection<String> supportedPermissionTypes) {
        setSupportedPermissionTypes(supportedPermissionTypes);
        return this;
    }

    /**
     * <p>
     * A list of supported permission types.
     * </p>
     * 
     * @param supportedPermissionTypes
     *        A list of supported permission types.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PermissionType
     */

    public GetUnfilteredPartitionsMetadataRequest withSupportedPermissionTypes(PermissionType... supportedPermissionTypes) {
        java.util.ArrayList<String> supportedPermissionTypesCopy = new java.util.ArrayList<String>(supportedPermissionTypes.length);
        for (PermissionType value : supportedPermissionTypes) {
            supportedPermissionTypesCopy.add(value.toString());
        }
        if (getSupportedPermissionTypes() == null) {
            setSupportedPermissionTypes(supportedPermissionTypesCopy);
        } else {
            getSupportedPermissionTypes().addAll(supportedPermissionTypesCopy);
        }
        return this;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these partitions.
     * </p>
     * 
     * @param nextToken
     *        A continuation token, if this is not the first call to retrieve these partitions.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these partitions.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve these partitions.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these partitions.
     * </p>
     * 
     * @param nextToken
     *        A continuation token, if this is not the first call to retrieve these partitions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The segment of the table's partitions to scan in this request.
     * </p>
     * 
     * @param segment
     *        The segment of the table's partitions to scan in this request.
     */

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    /**
     * <p>
     * The segment of the table's partitions to scan in this request.
     * </p>
     * 
     * @return The segment of the table's partitions to scan in this request.
     */

    public Segment getSegment() {
        return this.segment;
    }

    /**
     * <p>
     * The segment of the table's partitions to scan in this request.
     * </p>
     * 
     * @param segment
     *        The segment of the table's partitions to scan in this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withSegment(Segment segment) {
        setSegment(segment);
        return this;
    }

    /**
     * <p>
     * The maximum number of partitions to return in a single response.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of partitions to return in a single response.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of partitions to return in a single response.
     * </p>
     * 
     * @return The maximum number of partitions to return in a single response.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of partitions to return in a single response.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of partitions to return in a single response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredPartitionsMetadataRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCatalogId() != null)
            sb.append("CatalogId: ").append(getCatalogId()).append(",");
        if (getDatabaseName() != null)
            sb.append("DatabaseName: ").append(getDatabaseName()).append(",");
        if (getTableName() != null)
            sb.append("TableName: ").append(getTableName()).append(",");
        if (getExpression() != null)
            sb.append("Expression: ").append(getExpression()).append(",");
        if (getAuditContext() != null)
            sb.append("AuditContext: ").append(getAuditContext()).append(",");
        if (getSupportedPermissionTypes() != null)
            sb.append("SupportedPermissionTypes: ").append(getSupportedPermissionTypes()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getSegment() != null)
            sb.append("Segment: ").append(getSegment()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetUnfilteredPartitionsMetadataRequest == false)
            return false;
        GetUnfilteredPartitionsMetadataRequest other = (GetUnfilteredPartitionsMetadataRequest) obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null)
            return false;
        if (other.getCatalogId() != null && other.getCatalogId().equals(this.getCatalogId()) == false)
            return false;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null)
            return false;
        if (other.getDatabaseName() != null && other.getDatabaseName().equals(this.getDatabaseName()) == false)
            return false;
        if (other.getTableName() == null ^ this.getTableName() == null)
            return false;
        if (other.getTableName() != null && other.getTableName().equals(this.getTableName()) == false)
            return false;
        if (other.getExpression() == null ^ this.getExpression() == null)
            return false;
        if (other.getExpression() != null && other.getExpression().equals(this.getExpression()) == false)
            return false;
        if (other.getAuditContext() == null ^ this.getAuditContext() == null)
            return false;
        if (other.getAuditContext() != null && other.getAuditContext().equals(this.getAuditContext()) == false)
            return false;
        if (other.getSupportedPermissionTypes() == null ^ this.getSupportedPermissionTypes() == null)
            return false;
        if (other.getSupportedPermissionTypes() != null && other.getSupportedPermissionTypes().equals(this.getSupportedPermissionTypes()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getSegment() == null ^ this.getSegment() == null)
            return false;
        if (other.getSegment() != null && other.getSegment().equals(this.getSegment()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCatalogId() == null) ? 0 : getCatalogId().hashCode());
        hashCode = prime * hashCode + ((getDatabaseName() == null) ? 0 : getDatabaseName().hashCode());
        hashCode = prime * hashCode + ((getTableName() == null) ? 0 : getTableName().hashCode());
        hashCode = prime * hashCode + ((getExpression() == null) ? 0 : getExpression().hashCode());
        hashCode = prime * hashCode + ((getAuditContext() == null) ? 0 : getAuditContext().hashCode());
        hashCode = prime * hashCode + ((getSupportedPermissionTypes() == null) ? 0 : getSupportedPermissionTypes().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getSegment() == null) ? 0 : getSegment().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public GetUnfilteredPartitionsMetadataRequest clone() {
        return (GetUnfilteredPartitionsMetadataRequest) super.clone();
    }

}
