/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents a JDBC database output object which defines the output destination for a DataBrew recipe job to write
 * into.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DatabaseOutput" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DatabaseOutput implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Glue connection that stores the connection information for the target database.
     * </p>
     */
    private String glueConnectionName;
    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     */
    private DatabaseTableOutputOptions databaseOptions;
    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     */
    private String databaseOutputMode;

    /**
     * <p>
     * The Glue connection that stores the connection information for the target database.
     * </p>
     * 
     * @param glueConnectionName
     *        The Glue connection that stores the connection information for the target database.
     */

    public void setGlueConnectionName(String glueConnectionName) {
        this.glueConnectionName = glueConnectionName;
    }

    /**
     * <p>
     * The Glue connection that stores the connection information for the target database.
     * </p>
     * 
     * @return The Glue connection that stores the connection information for the target database.
     */

    public String getGlueConnectionName() {
        return this.glueConnectionName;
    }

    /**
     * <p>
     * The Glue connection that stores the connection information for the target database.
     * </p>
     * 
     * @param glueConnectionName
     *        The Glue connection that stores the connection information for the target database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DatabaseOutput withGlueConnectionName(String glueConnectionName) {
        setGlueConnectionName(glueConnectionName);
        return this;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @param databaseOptions
     *        Represents options that specify how and where DataBrew writes the database output generated by recipe
     *        jobs.
     */

    public void setDatabaseOptions(DatabaseTableOutputOptions databaseOptions) {
        this.databaseOptions = databaseOptions;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the database output generated by recipe
     *         jobs.
     */

    public DatabaseTableOutputOptions getDatabaseOptions() {
        return this.databaseOptions;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @param databaseOptions
     *        Represents options that specify how and where DataBrew writes the database output generated by recipe
     *        jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DatabaseOutput withDatabaseOptions(DatabaseTableOutputOptions databaseOptions) {
        setDatabaseOptions(databaseOptions);
        return this;
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * 
     * @param databaseOutputMode
     *        The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @see DatabaseOutputMode
     */

    public void setDatabaseOutputMode(String databaseOutputMode) {
        this.databaseOutputMode = databaseOutputMode;
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * 
     * @return The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @see DatabaseOutputMode
     */

    public String getDatabaseOutputMode() {
        return this.databaseOutputMode;
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * 
     * @param databaseOutputMode
     *        The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DatabaseOutputMode
     */

    public DatabaseOutput withDatabaseOutputMode(String databaseOutputMode) {
        setDatabaseOutputMode(databaseOutputMode);
        return this;
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * 
     * @param databaseOutputMode
     *        The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DatabaseOutputMode
     */

    public DatabaseOutput withDatabaseOutputMode(DatabaseOutputMode databaseOutputMode) {
        this.databaseOutputMode = databaseOutputMode.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGlueConnectionName() != null)
            sb.append("GlueConnectionName: ").append(getGlueConnectionName()).append(",");
        if (getDatabaseOptions() != null)
            sb.append("DatabaseOptions: ").append(getDatabaseOptions()).append(",");
        if (getDatabaseOutputMode() != null)
            sb.append("DatabaseOutputMode: ").append(getDatabaseOutputMode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DatabaseOutput == false)
            return false;
        DatabaseOutput other = (DatabaseOutput) obj;
        if (other.getGlueConnectionName() == null ^ this.getGlueConnectionName() == null)
            return false;
        if (other.getGlueConnectionName() != null && other.getGlueConnectionName().equals(this.getGlueConnectionName()) == false)
            return false;
        if (other.getDatabaseOptions() == null ^ this.getDatabaseOptions() == null)
            return false;
        if (other.getDatabaseOptions() != null && other.getDatabaseOptions().equals(this.getDatabaseOptions()) == false)
            return false;
        if (other.getDatabaseOutputMode() == null ^ this.getDatabaseOutputMode() == null)
            return false;
        if (other.getDatabaseOutputMode() != null && other.getDatabaseOutputMode().equals(this.getDatabaseOutputMode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGlueConnectionName() == null) ? 0 : getGlueConnectionName().hashCode());
        hashCode = prime * hashCode + ((getDatabaseOptions() == null) ? 0 : getDatabaseOptions().hashCode());
        hashCode = prime * hashCode + ((getDatabaseOutputMode() == null) ? 0 : getDatabaseOutputMode().hashCode());
        return hashCode;
    }

    @Override
    public DatabaseOutput clone() {
        try {
            return (DatabaseOutput) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.gluedatabrew.model.transform.DatabaseOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
