/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gluedatabrew.model.Schedule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSchedulesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Schedule> schedules;
    private String nextToken;

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<Schedule> schedules) {
        if (schedules == null) {
            this.schedules = null;
            return;
        }
        this.schedules = new ArrayList<Schedule>(schedules);
    }

    public ListSchedulesResult withSchedules(Schedule ... schedules) {
        if (this.schedules == null) {
            this.setSchedules(new ArrayList<Schedule>(schedules.length));
        }
        for (Schedule ele : schedules) {
            this.schedules.add(ele);
        }
        return this;
    }

    public ListSchedulesResult withSchedules(Collection<Schedule> schedules) {
        this.setSchedules(schedules);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSchedulesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSchedules() != null) {
            sb.append("Schedules: ").append(this.getSchedules()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulesResult)) {
            return false;
        }
        ListSchedulesResult other = (ListSchedulesResult)obj;
        if (other.getSchedules() == null ^ this.getSchedules() == null) {
            return false;
        }
        if (other.getSchedules() != null && !other.getSchedules().equals(this.getSchedules())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSchedules() == null ? 0 : this.getSchedules().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSchedulesResult clone() {
        try {
            return (ListSchedulesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

