/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Organization-wide Malware Protection configurations.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/OrganizationMalwareProtectionConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OrganizationMalwareProtectionConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining the
     * organization.
     * </p>
     */
    private OrganizationScanEc2InstanceWithFindings scanEc2InstanceWithFindings;

    /**
     * <p>
     * Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining the
     * organization.
     * </p>
     * 
     * @param scanEc2InstanceWithFindings
     *        Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining
     *        the organization.
     */

    public void setScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindings scanEc2InstanceWithFindings) {
        this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining the
     * organization.
     * </p>
     * 
     * @return Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining
     *         the organization.
     */

    public OrganizationScanEc2InstanceWithFindings getScanEc2InstanceWithFindings() {
        return this.scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining the
     * organization.
     * </p>
     * 
     * @param scanEc2InstanceWithFindings
     *        Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining
     *        the organization.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationMalwareProtectionConfiguration withScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindings scanEc2InstanceWithFindings) {
        setScanEc2InstanceWithFindings(scanEc2InstanceWithFindings);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScanEc2InstanceWithFindings() != null)
            sb.append("ScanEc2InstanceWithFindings: ").append(getScanEc2InstanceWithFindings());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OrganizationMalwareProtectionConfiguration == false)
            return false;
        OrganizationMalwareProtectionConfiguration other = (OrganizationMalwareProtectionConfiguration) obj;
        if (other.getScanEc2InstanceWithFindings() == null ^ this.getScanEc2InstanceWithFindings() == null)
            return false;
        if (other.getScanEc2InstanceWithFindings() != null && other.getScanEc2InstanceWithFindings().equals(this.getScanEc2InstanceWithFindings()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScanEc2InstanceWithFindings() == null) ? 0 : getScanEc2InstanceWithFindings().hashCode());
        return hashCode;
    }

    @Override
    public OrganizationMalwareProtectionConfiguration clone() {
        try {
            return (OrganizationMalwareProtectionConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.guardduty.model.transform.OrganizationMalwareProtectionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
