/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.honeycode.AmazonHoneycode;
import com.amazonaws.services.honeycode.AmazonHoneycodeClientBuilder;
import com.amazonaws.services.honeycode.model.AmazonHoneycodeException;
import com.amazonaws.services.honeycode.model.BatchCreateTableRowsRequest;
import com.amazonaws.services.honeycode.model.BatchCreateTableRowsResult;
import com.amazonaws.services.honeycode.model.BatchDeleteTableRowsRequest;
import com.amazonaws.services.honeycode.model.BatchDeleteTableRowsResult;
import com.amazonaws.services.honeycode.model.BatchUpdateTableRowsRequest;
import com.amazonaws.services.honeycode.model.BatchUpdateTableRowsResult;
import com.amazonaws.services.honeycode.model.BatchUpsertTableRowsRequest;
import com.amazonaws.services.honeycode.model.BatchUpsertTableRowsResult;
import com.amazonaws.services.honeycode.model.DescribeTableDataImportJobRequest;
import com.amazonaws.services.honeycode.model.DescribeTableDataImportJobResult;
import com.amazonaws.services.honeycode.model.GetScreenDataRequest;
import com.amazonaws.services.honeycode.model.GetScreenDataResult;
import com.amazonaws.services.honeycode.model.InvokeScreenAutomationRequest;
import com.amazonaws.services.honeycode.model.InvokeScreenAutomationResult;
import com.amazonaws.services.honeycode.model.ListTableColumnsRequest;
import com.amazonaws.services.honeycode.model.ListTableColumnsResult;
import com.amazonaws.services.honeycode.model.ListTableRowsRequest;
import com.amazonaws.services.honeycode.model.ListTableRowsResult;
import com.amazonaws.services.honeycode.model.ListTablesRequest;
import com.amazonaws.services.honeycode.model.ListTablesResult;
import com.amazonaws.services.honeycode.model.QueryTableRowsRequest;
import com.amazonaws.services.honeycode.model.QueryTableRowsResult;
import com.amazonaws.services.honeycode.model.StartTableDataImportJobRequest;
import com.amazonaws.services.honeycode.model.StartTableDataImportJobResult;
import com.amazonaws.services.honeycode.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.AutomationExecutionExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.AutomationExecutionTimeoutExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchCreateTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchCreateTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchDeleteTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchDeleteTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchUpdateTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchUpdateTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchUpsertTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.BatchUpsertTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.DescribeTableDataImportJobRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.DescribeTableDataImportJobResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.GetScreenDataRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.GetScreenDataResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.InvokeScreenAutomationRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.InvokeScreenAutomationResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTableColumnsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTableColumnsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTablesRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.QueryTableRowsRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.QueryTableRowsResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.StartTableDataImportJobRequestProtocolMarshaller;
import com.amazonaws.services.honeycode.model.transform.StartTableDataImportJobResultJsonUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.honeycode.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonHoneycodeClient
extends AmazonWebServiceClient
implements AmazonHoneycode {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonHoneycode.class);
    private static final String DEFAULT_SIGNING_NAME = "honeycode";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AutomationExecutionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AutomationExecutionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AutomationExecutionTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AutomationExecutionTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonHoneycodeException.class));

    public static AmazonHoneycodeClientBuilder builder() {
        return AmazonHoneycodeClientBuilder.standard();
    }

    AmazonHoneycodeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonHoneycodeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("honeycode.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/honeycode/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/honeycode/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCreateTableRowsResult batchCreateTableRows(BatchCreateTableRowsRequest request) {
        request = (BatchCreateTableRowsRequest)this.beforeClientExecution(request);
        return this.executeBatchCreateTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCreateTableRowsResult executeBatchCreateTableRows(BatchCreateTableRowsRequest batchCreateTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCreateTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCreateTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCreateTableRowsRequestProtocolMarshaller(protocolFactory).marshall((BatchCreateTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCreateTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchCreateTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCreateTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCreateTableRowsResult batchCreateTableRowsResult = (BatchCreateTableRowsResult)response.getAwsResponse();
            return batchCreateTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteTableRowsResult batchDeleteTableRows(BatchDeleteTableRowsRequest request) {
        request = (BatchDeleteTableRowsRequest)this.beforeClientExecution(request);
        return this.executeBatchDeleteTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteTableRowsResult executeBatchDeleteTableRows(BatchDeleteTableRowsRequest batchDeleteTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteTableRowsRequestProtocolMarshaller(protocolFactory).marshall((BatchDeleteTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDeleteTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteTableRowsResult batchDeleteTableRowsResult = (BatchDeleteTableRowsResult)response.getAwsResponse();
            return batchDeleteTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUpdateTableRowsResult batchUpdateTableRows(BatchUpdateTableRowsRequest request) {
        request = (BatchUpdateTableRowsRequest)this.beforeClientExecution(request);
        return this.executeBatchUpdateTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateTableRowsResult executeBatchUpdateTableRows(BatchUpdateTableRowsRequest batchUpdateTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateTableRowsRequestProtocolMarshaller(protocolFactory).marshall((BatchUpdateTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUpdateTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUpdateTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUpdateTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpdateTableRowsResult batchUpdateTableRowsResult = (BatchUpdateTableRowsResult)response.getAwsResponse();
            return batchUpdateTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUpsertTableRowsResult batchUpsertTableRows(BatchUpsertTableRowsRequest request) {
        request = (BatchUpsertTableRowsRequest)this.beforeClientExecution(request);
        return this.executeBatchUpsertTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpsertTableRowsResult executeBatchUpsertTableRows(BatchUpsertTableRowsRequest batchUpsertTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpsertTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpsertTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpsertTableRowsRequestProtocolMarshaller(protocolFactory).marshall((BatchUpsertTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUpsertTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUpsertTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUpsertTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpsertTableRowsResult batchUpsertTableRowsResult = (BatchUpsertTableRowsResult)response.getAwsResponse();
            return batchUpsertTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTableDataImportJobResult describeTableDataImportJob(DescribeTableDataImportJobRequest request) {
        request = (DescribeTableDataImportJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeTableDataImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTableDataImportJobResult executeDescribeTableDataImportJob(DescribeTableDataImportJobRequest describeTableDataImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTableDataImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTableDataImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTableDataImportJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeTableDataImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTableDataImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTableDataImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTableDataImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTableDataImportJobResult describeTableDataImportJobResult = (DescribeTableDataImportJobResult)response.getAwsResponse();
            return describeTableDataImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetScreenDataResult getScreenData(GetScreenDataRequest request) {
        request = (GetScreenDataRequest)this.beforeClientExecution(request);
        return this.executeGetScreenData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetScreenDataResult executeGetScreenData(GetScreenDataRequest getScreenDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getScreenDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetScreenDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetScreenDataRequestProtocolMarshaller(protocolFactory).marshall((GetScreenDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getScreenDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetScreenData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetScreenDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetScreenDataResult getScreenDataResult = (GetScreenDataResult)response.getAwsResponse();
            return getScreenDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InvokeScreenAutomationResult invokeScreenAutomation(InvokeScreenAutomationRequest request) {
        request = (InvokeScreenAutomationRequest)this.beforeClientExecution(request);
        return this.executeInvokeScreenAutomation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InvokeScreenAutomationResult executeInvokeScreenAutomation(InvokeScreenAutomationRequest invokeScreenAutomationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeScreenAutomationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeScreenAutomationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeScreenAutomationRequestProtocolMarshaller(protocolFactory).marshall((InvokeScreenAutomationRequest)super.beforeMarshalling((AmazonWebServiceRequest)invokeScreenAutomationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InvokeScreenAutomation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeScreenAutomationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InvokeScreenAutomationResult invokeScreenAutomationResult = (InvokeScreenAutomationResult)response.getAwsResponse();
            return invokeScreenAutomationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTableColumnsResult listTableColumns(ListTableColumnsRequest request) {
        request = (ListTableColumnsRequest)this.beforeClientExecution(request);
        return this.executeListTableColumns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTableColumnsResult executeListTableColumns(ListTableColumnsRequest listTableColumnsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTableColumnsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTableColumnsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTableColumnsRequestProtocolMarshaller(protocolFactory).marshall((ListTableColumnsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTableColumnsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTableColumns");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTableColumnsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTableColumnsResult listTableColumnsResult = (ListTableColumnsResult)response.getAwsResponse();
            return listTableColumnsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTableRowsResult listTableRows(ListTableRowsRequest request) {
        request = (ListTableRowsRequest)this.beforeClientExecution(request);
        return this.executeListTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTableRowsResult executeListTableRows(ListTableRowsRequest listTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTableRowsRequestProtocolMarshaller(protocolFactory).marshall((ListTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTableRowsResult listTableRowsResult = (ListTableRowsResult)response.getAwsResponse();
            return listTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest request) {
        request = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executeListTables(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTablesResult executeListTables(ListTablesRequest listTablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTablesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTablesRequestProtocolMarshaller(protocolFactory).marshall((ListTablesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTablesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTables");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTablesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTablesResult listTablesResult = (ListTablesResult)response.getAwsResponse();
            return listTablesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public QueryTableRowsResult queryTableRows(QueryTableRowsRequest request) {
        request = (QueryTableRowsRequest)this.beforeClientExecution(request);
        return this.executeQueryTableRows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final QueryTableRowsResult executeQueryTableRows(QueryTableRowsRequest queryTableRowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(queryTableRowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<QueryTableRowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new QueryTableRowsRequestProtocolMarshaller(protocolFactory).marshall((QueryTableRowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)queryTableRowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"QueryTableRows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new QueryTableRowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            QueryTableRowsResult queryTableRowsResult = (QueryTableRowsResult)response.getAwsResponse();
            return queryTableRowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTableDataImportJobResult startTableDataImportJob(StartTableDataImportJobRequest request) {
        request = (StartTableDataImportJobRequest)this.beforeClientExecution(request);
        return this.executeStartTableDataImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTableDataImportJobResult executeStartTableDataImportJob(StartTableDataImportJobRequest startTableDataImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTableDataImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTableDataImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTableDataImportJobRequestProtocolMarshaller(protocolFactory).marshall((StartTableDataImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTableDataImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Honeycode");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTableDataImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTableDataImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTableDataImportJobResult startTableDataImportJobResult = (StartTableDataImportJobResult)response.getAwsResponse();
            return startTableDataImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

