/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.honeycode.model.Cell;
import com.amazonaws.services.honeycode.model.transform.TableRowMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableRow
implements Serializable,
Cloneable,
StructuredPojo {
    private String rowId;
    private List<Cell> cells;

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getRowId() {
        return this.rowId;
    }

    public TableRow withRowId(String rowId) {
        this.setRowId(rowId);
        return this;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(Collection<Cell> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<Cell>(cells);
    }

    public TableRow withCells(Cell ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<Cell>(cells.length));
        }
        for (Cell ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public TableRow withCells(Collection<Cell> cells) {
        this.setCells(cells);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRowId() != null) {
            sb.append("RowId: ").append(this.getRowId()).append(",");
        }
        if (this.getCells() != null) {
            sb.append("Cells: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)obj;
        if (other.getRowId() == null ^ this.getRowId() == null) {
            return false;
        }
        if (other.getRowId() != null && !other.getRowId().equals(this.getRowId())) {
            return false;
        }
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        return other.getCells() == null || other.getCells().equals(this.getCells());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRowId() == null ? 0 : this.getRowId().hashCode());
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        return hashCode;
    }

    public TableRow clone() {
        try {
            return (TableRow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableRowMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

