/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListAccessKeysRequestMarshaller
implements Marshaller<Request<ListAccessKeysRequest>, ListAccessKeysRequest> {
    public Request<ListAccessKeysRequest> marshall(ListAccessKeysRequest listAccessKeysRequest) {
        if (listAccessKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAccessKeysRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "ListAccessKeys");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listAccessKeysRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)listAccessKeysRequest.getUserName()));
        }
        if (listAccessKeysRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listAccessKeysRequest.getMarker()));
        }
        if (listAccessKeysRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listAccessKeysRequest.getMaxItems()));
        }
        return request;
    }
}

