/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.identitymanagement.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 */
public class RemoveUserFromGroupRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the group to update.
     * </p>
     */
    private String groupName;
    /**
     * <p>
     * The name of the user to remove.
     * </p>
     */
    private String userName;

    /**
     * Default constructor for RemoveUserFromGroupRequest object. Callers should
     * use the setter or fluent setter (with...) methods to initialize the
     * object after creating it.
     */
    public RemoveUserFromGroupRequest() {
    }

    /**
     * Constructs a new RemoveUserFromGroupRequest object. Callers should use
     * the setter or fluent setter (with...) methods to initialize any
     * additional object members.
     * 
     * @param groupName
     *        The name of the group to update.
     * @param userName
     *        The name of the user to remove.
     */
    public RemoveUserFromGroupRequest(String groupName, String userName) {
        setGroupName(groupName);
        setUserName(userName);
    }

    /**
     * <p>
     * The name of the group to update.
     * </p>
     * 
     * @param groupName
     *        The name of the group to update.
     */

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /**
     * <p>
     * The name of the group to update.
     * </p>
     * 
     * @return The name of the group to update.
     */

    public String getGroupName() {
        return this.groupName;
    }

    /**
     * <p>
     * The name of the group to update.
     * </p>
     * 
     * @param groupName
     *        The name of the group to update.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RemoveUserFromGroupRequest withGroupName(String groupName) {
        setGroupName(groupName);
        return this;
    }

    /**
     * <p>
     * The name of the user to remove.
     * </p>
     * 
     * @param userName
     *        The name of the user to remove.
     */

    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * <p>
     * The name of the user to remove.
     * </p>
     * 
     * @return The name of the user to remove.
     */

    public String getUserName() {
        return this.userName;
    }

    /**
     * <p>
     * The name of the user to remove.
     * </p>
     * 
     * @param userName
     *        The name of the user to remove.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RemoveUserFromGroupRequest withUserName(String userName) {
        setUserName(userName);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroupName() != null)
            sb.append("GroupName: " + getGroupName() + ",");
        if (getUserName() != null)
            sb.append("UserName: " + getUserName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RemoveUserFromGroupRequest == false)
            return false;
        RemoveUserFromGroupRequest other = (RemoveUserFromGroupRequest) obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null)
            return false;
        if (other.getGroupName() != null
                && other.getGroupName().equals(this.getGroupName()) == false)
            return false;
        if (other.getUserName() == null ^ this.getUserName() == null)
            return false;
        if (other.getUserName() != null
                && other.getUserName().equals(this.getUserName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getGroupName() == null) ? 0 : getGroupName().hashCode());
        hashCode = prime * hashCode
                + ((getUserName() == null) ? 0 : getUserName().hashCode());
        return hashCode;
    }

    @Override
    public RemoveUserFromGroupRequest clone() {
        return (RemoveUserFromGroupRequest) super.clone();
    }
}