/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TagInstanceProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceProfileName;
    private SdkInternalList<Tag> tags;

    public void setInstanceProfileName(String instanceProfileName) {
        this.instanceProfileName = instanceProfileName;
    }

    public String getInstanceProfileName() {
        return this.instanceProfileName;
    }

    public TagInstanceProfileRequest withInstanceProfileName(String instanceProfileName) {
        this.setInstanceProfileName(instanceProfileName);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public TagInstanceProfileRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public TagInstanceProfileRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceProfileName() != null) {
            sb.append("InstanceProfileName: ").append(this.getInstanceProfileName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagInstanceProfileRequest)) {
            return false;
        }
        TagInstanceProfileRequest other = (TagInstanceProfileRequest)obj;
        if (other.getInstanceProfileName() == null ^ this.getInstanceProfileName() == null) {
            return false;
        }
        if (other.getInstanceProfileName() != null && !other.getInstanceProfileName().equals(this.getInstanceProfileName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceProfileName() == null ? 0 : this.getInstanceProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagInstanceProfileRequest clone() {
        return (TagInstanceProfileRequest)super.clone();
    }
}

