/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.identitystore.AWSIdentityStoreAsync;
import com.amazonaws.services.identitystore.AWSIdentityStoreAsyncClientBuilder;
import com.amazonaws.services.identitystore.AWSIdentityStoreClient;
import com.amazonaws.services.identitystore.model.CreateGroupMembershipRequest;
import com.amazonaws.services.identitystore.model.CreateGroupMembershipResult;
import com.amazonaws.services.identitystore.model.CreateGroupRequest;
import com.amazonaws.services.identitystore.model.CreateGroupResult;
import com.amazonaws.services.identitystore.model.CreateUserRequest;
import com.amazonaws.services.identitystore.model.CreateUserResult;
import com.amazonaws.services.identitystore.model.DeleteGroupMembershipRequest;
import com.amazonaws.services.identitystore.model.DeleteGroupMembershipResult;
import com.amazonaws.services.identitystore.model.DeleteGroupRequest;
import com.amazonaws.services.identitystore.model.DeleteGroupResult;
import com.amazonaws.services.identitystore.model.DeleteUserRequest;
import com.amazonaws.services.identitystore.model.DeleteUserResult;
import com.amazonaws.services.identitystore.model.DescribeGroupMembershipRequest;
import com.amazonaws.services.identitystore.model.DescribeGroupMembershipResult;
import com.amazonaws.services.identitystore.model.DescribeGroupRequest;
import com.amazonaws.services.identitystore.model.DescribeGroupResult;
import com.amazonaws.services.identitystore.model.DescribeUserRequest;
import com.amazonaws.services.identitystore.model.DescribeUserResult;
import com.amazonaws.services.identitystore.model.GetGroupIdRequest;
import com.amazonaws.services.identitystore.model.GetGroupIdResult;
import com.amazonaws.services.identitystore.model.GetGroupMembershipIdRequest;
import com.amazonaws.services.identitystore.model.GetGroupMembershipIdResult;
import com.amazonaws.services.identitystore.model.GetUserIdRequest;
import com.amazonaws.services.identitystore.model.GetUserIdResult;
import com.amazonaws.services.identitystore.model.IsMemberInGroupsRequest;
import com.amazonaws.services.identitystore.model.IsMemberInGroupsResult;
import com.amazonaws.services.identitystore.model.ListGroupMembershipsForMemberRequest;
import com.amazonaws.services.identitystore.model.ListGroupMembershipsForMemberResult;
import com.amazonaws.services.identitystore.model.ListGroupMembershipsRequest;
import com.amazonaws.services.identitystore.model.ListGroupMembershipsResult;
import com.amazonaws.services.identitystore.model.ListGroupsRequest;
import com.amazonaws.services.identitystore.model.ListGroupsResult;
import com.amazonaws.services.identitystore.model.ListUsersRequest;
import com.amazonaws.services.identitystore.model.ListUsersResult;
import com.amazonaws.services.identitystore.model.UpdateGroupRequest;
import com.amazonaws.services.identitystore.model.UpdateGroupResult;
import com.amazonaws.services.identitystore.model.UpdateUserRequest;
import com.amazonaws.services.identitystore.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIdentityStoreAsyncClient
extends AWSIdentityStoreClient
implements AWSIdentityStoreAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIdentityStoreAsyncClientBuilder asyncBuilder() {
        return AWSIdentityStoreAsyncClientBuilder.standard();
    }

    AWSIdentityStoreAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIdentityStoreAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupAsync(request, null);
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request, final AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {
        final CreateGroupRequest finalRequest = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupResult>(){

            @Override
            public CreateGroupResult call() throws Exception {
                CreateGroupResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeCreateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGroupMembershipResult> createGroupMembershipAsync(CreateGroupMembershipRequest request) {
        return this.createGroupMembershipAsync(request, null);
    }

    @Override
    public Future<CreateGroupMembershipResult> createGroupMembershipAsync(CreateGroupMembershipRequest request, final AsyncHandler<CreateGroupMembershipRequest, CreateGroupMembershipResult> asyncHandler) {
        final CreateGroupMembershipRequest finalRequest = (CreateGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupMembershipResult>(){

            @Override
            public CreateGroupMembershipResult call() throws Exception {
                CreateGroupMembershipResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeCreateGroupMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupAsync(request, null);
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request, final AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {
        final DeleteGroupRequest finalRequest = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupResult>(){

            @Override
            public DeleteGroupResult call() throws Exception {
                DeleteGroupResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDeleteGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupMembershipResult> deleteGroupMembershipAsync(DeleteGroupMembershipRequest request) {
        return this.deleteGroupMembershipAsync(request, null);
    }

    @Override
    public Future<DeleteGroupMembershipResult> deleteGroupMembershipAsync(DeleteGroupMembershipRequest request, final AsyncHandler<DeleteGroupMembershipRequest, DeleteGroupMembershipResult> asyncHandler) {
        final DeleteGroupMembershipRequest finalRequest = (DeleteGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupMembershipResult>(){

            @Override
            public DeleteGroupMembershipResult call() throws Exception {
                DeleteGroupMembershipResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDeleteGroupMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request) {
        return this.describeGroupAsync(request, null);
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request, final AsyncHandler<DescribeGroupRequest, DescribeGroupResult> asyncHandler) {
        final DescribeGroupRequest finalRequest = (DescribeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGroupResult>(){

            @Override
            public DescribeGroupResult call() throws Exception {
                DescribeGroupResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDescribeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGroupMembershipResult> describeGroupMembershipAsync(DescribeGroupMembershipRequest request) {
        return this.describeGroupMembershipAsync(request, null);
    }

    @Override
    public Future<DescribeGroupMembershipResult> describeGroupMembershipAsync(DescribeGroupMembershipRequest request, final AsyncHandler<DescribeGroupMembershipRequest, DescribeGroupMembershipResult> asyncHandler) {
        final DescribeGroupMembershipRequest finalRequest = (DescribeGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGroupMembershipResult>(){

            @Override
            public DescribeGroupMembershipResult call() throws Exception {
                DescribeGroupMembershipResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDescribeGroupMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupIdResult> getGroupIdAsync(GetGroupIdRequest request) {
        return this.getGroupIdAsync(request, null);
    }

    @Override
    public Future<GetGroupIdResult> getGroupIdAsync(GetGroupIdRequest request, final AsyncHandler<GetGroupIdRequest, GetGroupIdResult> asyncHandler) {
        final GetGroupIdRequest finalRequest = (GetGroupIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupIdResult>(){

            @Override
            public GetGroupIdResult call() throws Exception {
                GetGroupIdResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeGetGroupId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupMembershipIdResult> getGroupMembershipIdAsync(GetGroupMembershipIdRequest request) {
        return this.getGroupMembershipIdAsync(request, null);
    }

    @Override
    public Future<GetGroupMembershipIdResult> getGroupMembershipIdAsync(GetGroupMembershipIdRequest request, final AsyncHandler<GetGroupMembershipIdRequest, GetGroupMembershipIdResult> asyncHandler) {
        final GetGroupMembershipIdRequest finalRequest = (GetGroupMembershipIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupMembershipIdResult>(){

            @Override
            public GetGroupMembershipIdResult call() throws Exception {
                GetGroupMembershipIdResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeGetGroupMembershipId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserIdResult> getUserIdAsync(GetUserIdRequest request) {
        return this.getUserIdAsync(request, null);
    }

    @Override
    public Future<GetUserIdResult> getUserIdAsync(GetUserIdRequest request, final AsyncHandler<GetUserIdRequest, GetUserIdResult> asyncHandler) {
        final GetUserIdRequest finalRequest = (GetUserIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUserIdResult>(){

            @Override
            public GetUserIdResult call() throws Exception {
                GetUserIdResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeGetUserId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IsMemberInGroupsResult> isMemberInGroupsAsync(IsMemberInGroupsRequest request) {
        return this.isMemberInGroupsAsync(request, null);
    }

    @Override
    public Future<IsMemberInGroupsResult> isMemberInGroupsAsync(IsMemberInGroupsRequest request, final AsyncHandler<IsMemberInGroupsRequest, IsMemberInGroupsResult> asyncHandler) {
        final IsMemberInGroupsRequest finalRequest = (IsMemberInGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IsMemberInGroupsResult>(){

            @Override
            public IsMemberInGroupsResult call() throws Exception {
                IsMemberInGroupsResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeIsMemberInGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupMembershipsResult> listGroupMembershipsAsync(ListGroupMembershipsRequest request) {
        return this.listGroupMembershipsAsync(request, null);
    }

    @Override
    public Future<ListGroupMembershipsResult> listGroupMembershipsAsync(ListGroupMembershipsRequest request, final AsyncHandler<ListGroupMembershipsRequest, ListGroupMembershipsResult> asyncHandler) {
        final ListGroupMembershipsRequest finalRequest = (ListGroupMembershipsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupMembershipsResult>(){

            @Override
            public ListGroupMembershipsResult call() throws Exception {
                ListGroupMembershipsResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListGroupMemberships(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupMembershipsForMemberResult> listGroupMembershipsForMemberAsync(ListGroupMembershipsForMemberRequest request) {
        return this.listGroupMembershipsForMemberAsync(request, null);
    }

    @Override
    public Future<ListGroupMembershipsForMemberResult> listGroupMembershipsForMemberAsync(ListGroupMembershipsForMemberRequest request, final AsyncHandler<ListGroupMembershipsForMemberRequest, ListGroupMembershipsForMemberResult> asyncHandler) {
        final ListGroupMembershipsForMemberRequest finalRequest = (ListGroupMembershipsForMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupMembershipsForMemberResult>(){

            @Override
            public ListGroupMembershipsForMemberResult call() throws Exception {
                ListGroupMembershipsForMemberResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListGroupMembershipsForMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {
        return this.listGroupsAsync(request, null);
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request, final AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {
        final ListGroupsRequest finalRequest = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupsResult>(){

            @Override
            public ListGroupsResult call() throws Exception {
                ListGroupsResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupAsync(request, null);
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request, final AsyncHandler<UpdateGroupRequest, UpdateGroupResult> asyncHandler) {
        final UpdateGroupRequest finalRequest = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGroupResult>(){

            @Override
            public UpdateGroupResult call() throws Exception {
                UpdateGroupResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeUpdateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

