/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.CreateComponentRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CreateComponentRequestMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> CHANGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("changeDescription").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<List> SUPPORTEDOSVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedOsVersions").build();
    private static final MarshallingInfo<String> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("data").build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CreateComponentRequestMarshaller instance = new CreateComponentRequestMarshaller();

    public static CreateComponentRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateComponentRequest createComponentRequest, ProtocolMarshaller protocolMarshaller) {
        if (createComponentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createComponentRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getSemanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getChangeDescription(), CHANGEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(createComponentRequest.getSupportedOsVersions(), SUPPORTEDOSVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getData(), DATA_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getUri(), URI_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(createComponentRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)createComponentRequest.getClientToken(), CLIENTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

