/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector.model.FailedItemDetails;
import com.amazonaws.services.inspector.model.RulesPackage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeRulesPackagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RulesPackage> rulesPackages;
    private Map<String, FailedItemDetails> failedItems;

    public List<RulesPackage> getRulesPackages() {
        return this.rulesPackages;
    }

    public void setRulesPackages(Collection<RulesPackage> rulesPackages) {
        if (rulesPackages == null) {
            this.rulesPackages = null;
            return;
        }
        this.rulesPackages = new ArrayList<RulesPackage>(rulesPackages);
    }

    public DescribeRulesPackagesResult withRulesPackages(RulesPackage ... rulesPackages) {
        if (this.rulesPackages == null) {
            this.setRulesPackages(new ArrayList<RulesPackage>(rulesPackages.length));
        }
        for (RulesPackage ele : rulesPackages) {
            this.rulesPackages.add(ele);
        }
        return this;
    }

    public DescribeRulesPackagesResult withRulesPackages(Collection<RulesPackage> rulesPackages) {
        this.setRulesPackages(rulesPackages);
        return this;
    }

    public Map<String, FailedItemDetails> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.failedItems = failedItems;
    }

    public DescribeRulesPackagesResult withFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public DescribeRulesPackagesResult addFailedItemsEntry(String key, FailedItemDetails value) {
        if (null == this.failedItems) {
            this.failedItems = new HashMap<String, FailedItemDetails>();
        }
        if (this.failedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.failedItems.put(key, value);
        return this;
    }

    public DescribeRulesPackagesResult clearFailedItemsEntries() {
        this.failedItems = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRulesPackages() != null) {
            sb.append("RulesPackages: " + this.getRulesPackages() + ",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: " + this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesPackagesResult)) {
            return false;
        }
        DescribeRulesPackagesResult other = (DescribeRulesPackagesResult)obj;
        if (other.getRulesPackages() == null ^ this.getRulesPackages() == null) {
            return false;
        }
        if (other.getRulesPackages() != null && !other.getRulesPackages().equals(this.getRulesPackages())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRulesPackages() == null ? 0 : this.getRulesPackages().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public DescribeRulesPackagesResult clone() {
        try {
            return (DescribeRulesPackagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

