/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRulesPackagesRequestMarshaller
implements Marshaller<Request<ListRulesPackagesRequest>, ListRulesPackagesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListRulesPackagesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListRulesPackagesRequest> marshall(ListRulesPackagesRequest listRulesPackagesRequest) {
        if (listRulesPackagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRulesPackagesRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListRulesPackages");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRulesPackagesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listRulesPackagesRequest.getNextToken());
            }
            if (listRulesPackagesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listRulesPackagesRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

