/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.PreviewAgentsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PreviewAgentsRequestMarshaller
implements Marshaller<Request<PreviewAgentsRequest>, PreviewAgentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PreviewAgentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PreviewAgentsRequest> marshall(PreviewAgentsRequest previewAgentsRequest) {
        if (previewAgentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)previewAgentsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.PreviewAgents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (previewAgentsRequest.getPreviewAgentsArn() != null) {
                jsonGenerator.writeFieldName("previewAgentsArn").writeValue(previewAgentsRequest.getPreviewAgentsArn());
            }
            if (previewAgentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(previewAgentsRequest.getNextToken());
            }
            if (previewAgentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(previewAgentsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

