/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector2.model.Finding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFindingsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Finding> findings;
    private String nextToken;

    public List<Finding> getFindings() {
        return this.findings;
    }

    public void setFindings(Collection<Finding> findings) {
        if (findings == null) {
            this.findings = null;
            return;
        }
        this.findings = new ArrayList<Finding>(findings);
    }

    public ListFindingsResult withFindings(Finding ... findings) {
        if (this.findings == null) {
            this.setFindings(new ArrayList<Finding>(findings.length));
        }
        for (Finding ele : findings) {
            this.findings.add(ele);
        }
        return this;
    }

    public ListFindingsResult withFindings(Collection<Finding> findings) {
        this.setFindings(findings);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFindingsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindings() != null) {
            sb.append("Findings: ").append(this.getFindings()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsResult)) {
            return false;
        }
        ListFindingsResult other = (ListFindingsResult)obj;
        if (other.getFindings() == null ^ this.getFindings() == null) {
            return false;
        }
        if (other.getFindings() != null && !other.getFindings().equals(this.getFindings())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindings() == null ? 0 : this.getFindings().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFindingsResult clone() {
        try {
            return (ListFindingsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

