/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchGetFreeTrialInfoResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     */
    private java.util.List<FreeTrialAccountInfo> accounts;
    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     */
    private java.util.List<FreeTrialInfoError> failedAccounts;

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     * 
     * @return An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     */

    public java.util.List<FreeTrialAccountInfo> getAccounts() {
        return accounts;
    }

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     * 
     * @param accounts
     *        An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     */

    public void setAccounts(java.util.Collection<FreeTrialAccountInfo> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }

        this.accounts = new java.util.ArrayList<FreeTrialAccountInfo>(accounts);
    }

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAccounts(java.util.Collection)} or {@link #withAccounts(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param accounts
     *        An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetFreeTrialInfoResult withAccounts(FreeTrialAccountInfo... accounts) {
        if (this.accounts == null) {
            setAccounts(new java.util.ArrayList<FreeTrialAccountInfo>(accounts.length));
        }
        for (FreeTrialAccountInfo ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     * 
     * @param accounts
     *        An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetFreeTrialInfoResult withAccounts(java.util.Collection<FreeTrialAccountInfo> accounts) {
        setAccounts(accounts);
        return this;
    }

    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     * 
     * @return An array of objects detailing any accounts that free trial data could not be returned for.
     */

    public java.util.List<FreeTrialInfoError> getFailedAccounts() {
        return failedAccounts;
    }

    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     * 
     * @param failedAccounts
     *        An array of objects detailing any accounts that free trial data could not be returned for.
     */

    public void setFailedAccounts(java.util.Collection<FreeTrialInfoError> failedAccounts) {
        if (failedAccounts == null) {
            this.failedAccounts = null;
            return;
        }

        this.failedAccounts = new java.util.ArrayList<FreeTrialInfoError>(failedAccounts);
    }

    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFailedAccounts(java.util.Collection)} or {@link #withFailedAccounts(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param failedAccounts
     *        An array of objects detailing any accounts that free trial data could not be returned for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetFreeTrialInfoResult withFailedAccounts(FreeTrialInfoError... failedAccounts) {
        if (this.failedAccounts == null) {
            setFailedAccounts(new java.util.ArrayList<FreeTrialInfoError>(failedAccounts.length));
        }
        for (FreeTrialInfoError ele : failedAccounts) {
            this.failedAccounts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     * 
     * @param failedAccounts
     *        An array of objects detailing any accounts that free trial data could not be returned for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetFreeTrialInfoResult withFailedAccounts(java.util.Collection<FreeTrialInfoError> failedAccounts) {
        setFailedAccounts(failedAccounts);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccounts() != null)
            sb.append("Accounts: ").append(getAccounts()).append(",");
        if (getFailedAccounts() != null)
            sb.append("FailedAccounts: ").append(getFailedAccounts());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchGetFreeTrialInfoResult == false)
            return false;
        BatchGetFreeTrialInfoResult other = (BatchGetFreeTrialInfoResult) obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null)
            return false;
        if (other.getAccounts() != null && other.getAccounts().equals(this.getAccounts()) == false)
            return false;
        if (other.getFailedAccounts() == null ^ this.getFailedAccounts() == null)
            return false;
        if (other.getFailedAccounts() != null && other.getFailedAccounts().equals(this.getFailedAccounts()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccounts() == null) ? 0 : getAccounts().hashCode());
        hashCode = prime * hashCode + ((getFailedAccounts() == null) ? 0 : getFailedAccounts().hashCode());
        return hashCode;
    }

    @Override
    public BatchGetFreeTrialInfoResult clone() {
        try {
            return (BatchGetFreeTrialInfoResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
