/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains information on the code vulnerability identified in your Lambda function.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CodeVulnerabilityDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CodeVulnerabilityDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     */
    private java.util.List<String> cwes;
    /**
     * <p>
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * </p>
     */
    private String detectorId;
    /**
     * <p>
     * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * </p>
     */
    private String detectorName;
    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     */
    private java.util.List<String> detectorTags;
    /**
     * <p>
     * Contains information on where the code vulnerability is located in your code.
     * </p>
     */
    private CodeFilePath filePath;
    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     */
    private java.util.List<String> referenceUrls;
    /**
     * <p>
     * The identifier for a rule that was used to detect the code vulnerability.
     * </p>
     */
    private String ruleId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * </p>
     */
    private String sourceLambdaLayerArn;

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     * 
     * @return The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     */

    public java.util.List<String> getCwes() {
        return cwes;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     */

    public void setCwes(java.util.Collection<String> cwes) {
        if (cwes == null) {
            this.cwes = null;
            return;
        }

        this.cwes = new java.util.ArrayList<String>(cwes);
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCwes(java.util.Collection)} or {@link #withCwes(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withCwes(String... cwes) {
        if (this.cwes == null) {
            setCwes(new java.util.ArrayList<String>(cwes.length));
        }
        for (String ele : cwes) {
            this.cwes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withCwes(java.util.Collection<String> cwes) {
        setCwes(cwes);
        return this;
    }

    /**
     * <p>
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * </p>
     * 
     * @param detectorId
     *        The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see
     *        <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     */

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    /**
     * <p>
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * </p>
     * 
     * @return The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors
     *         see <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     */

    public String getDetectorId() {
        return this.detectorId;
    }

    /**
     * <p>
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * </p>
     * 
     * @param detectorId
     *        The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see
     *        <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withDetectorId(String detectorId) {
        setDetectorId(detectorId);
        return this;
    }

    /**
     * <p>
     * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * </p>
     * 
     * @param detectorName
     *        The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     */

    public void setDetectorName(String detectorName) {
        this.detectorName = detectorName;
    }

    /**
     * <p>
     * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * </p>
     * 
     * @return The name of the detector used to identify the code vulnerability. For more information on detectors see
     *         <a href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     */

    public String getDetectorName() {
        return this.detectorName;
    }

    /**
     * <p>
     * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * </p>
     * 
     * @param detectorName
     *        The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withDetectorName(String detectorName) {
        setDetectorName(detectorName);
        return this;
    }

    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     * 
     * @return The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
     *         themes or tactics. For a list of available tags by programming language, see <a
     *         href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     *         href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     */

    public java.util.List<String> getDetectorTags() {
        return detectorTags;
    }

    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     * 
     * @param detectorTags
     *        The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
     *        themes or tactics. For a list of available tags by programming language, see <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     */

    public void setDetectorTags(java.util.Collection<String> detectorTags) {
        if (detectorTags == null) {
            this.detectorTags = null;
            return;
        }

        this.detectorTags = new java.util.ArrayList<String>(detectorTags);
    }

    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDetectorTags(java.util.Collection)} or {@link #withDetectorTags(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param detectorTags
     *        The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
     *        themes or tactics. For a list of available tags by programming language, see <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withDetectorTags(String... detectorTags) {
        if (this.detectorTags == null) {
            setDetectorTags(new java.util.ArrayList<String>(detectorTags.length));
        }
        for (String ele : detectorTags) {
            this.detectorTags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     * 
     * @param detectorTags
     *        The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
     *        themes or tactics. For a list of available tags by programming language, see <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     *        href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withDetectorTags(java.util.Collection<String> detectorTags) {
        setDetectorTags(detectorTags);
        return this;
    }

    /**
     * <p>
     * Contains information on where the code vulnerability is located in your code.
     * </p>
     * 
     * @param filePath
     *        Contains information on where the code vulnerability is located in your code.
     */

    public void setFilePath(CodeFilePath filePath) {
        this.filePath = filePath;
    }

    /**
     * <p>
     * Contains information on where the code vulnerability is located in your code.
     * </p>
     * 
     * @return Contains information on where the code vulnerability is located in your code.
     */

    public CodeFilePath getFilePath() {
        return this.filePath;
    }

    /**
     * <p>
     * Contains information on where the code vulnerability is located in your code.
     * </p>
     * 
     * @param filePath
     *        Contains information on where the code vulnerability is located in your code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withFilePath(CodeFilePath filePath) {
        setFilePath(filePath);
        return this;
    }

    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     * 
     * @return A URL containing supporting documentation about the code vulnerability detected.
     */

    public java.util.List<String> getReferenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     * 
     * @param referenceUrls
     *        A URL containing supporting documentation about the code vulnerability detected.
     */

    public void setReferenceUrls(java.util.Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }

        this.referenceUrls = new java.util.ArrayList<String>(referenceUrls);
    }

    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReferenceUrls(java.util.Collection)} or {@link #withReferenceUrls(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param referenceUrls
     *        A URL containing supporting documentation about the code vulnerability detected.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withReferenceUrls(String... referenceUrls) {
        if (this.referenceUrls == null) {
            setReferenceUrls(new java.util.ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     * 
     * @param referenceUrls
     *        A URL containing supporting documentation about the code vulnerability detected.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withReferenceUrls(java.util.Collection<String> referenceUrls) {
        setReferenceUrls(referenceUrls);
        return this;
    }

    /**
     * <p>
     * The identifier for a rule that was used to detect the code vulnerability.
     * </p>
     * 
     * @param ruleId
     *        The identifier for a rule that was used to detect the code vulnerability.
     */

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * <p>
     * The identifier for a rule that was used to detect the code vulnerability.
     * </p>
     * 
     * @return The identifier for a rule that was used to detect the code vulnerability.
     */

    public String getRuleId() {
        return this.ruleId;
    }

    /**
     * <p>
     * The identifier for a rule that was used to detect the code vulnerability.
     * </p>
     * 
     * @param ruleId
     *        The identifier for a rule that was used to detect the code vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withRuleId(String ruleId) {
        setRuleId(ruleId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * </p>
     * 
     * @param sourceLambdaLayerArn
     *        The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     */

    public void setSourceLambdaLayerArn(String sourceLambdaLayerArn) {
        this.sourceLambdaLayerArn = sourceLambdaLayerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     */

    public String getSourceLambdaLayerArn() {
        return this.sourceLambdaLayerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * </p>
     * 
     * @param sourceLambdaLayerArn
     *        The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeVulnerabilityDetails withSourceLambdaLayerArn(String sourceLambdaLayerArn) {
        setSourceLambdaLayerArn(sourceLambdaLayerArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCwes() != null)
            sb.append("Cwes: ").append(getCwes()).append(",");
        if (getDetectorId() != null)
            sb.append("DetectorId: ").append(getDetectorId()).append(",");
        if (getDetectorName() != null)
            sb.append("DetectorName: ").append(getDetectorName()).append(",");
        if (getDetectorTags() != null)
            sb.append("DetectorTags: ").append(getDetectorTags()).append(",");
        if (getFilePath() != null)
            sb.append("FilePath: ").append(getFilePath()).append(",");
        if (getReferenceUrls() != null)
            sb.append("ReferenceUrls: ").append(getReferenceUrls()).append(",");
        if (getRuleId() != null)
            sb.append("RuleId: ").append(getRuleId()).append(",");
        if (getSourceLambdaLayerArn() != null)
            sb.append("SourceLambdaLayerArn: ").append(getSourceLambdaLayerArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CodeVulnerabilityDetails == false)
            return false;
        CodeVulnerabilityDetails other = (CodeVulnerabilityDetails) obj;
        if (other.getCwes() == null ^ this.getCwes() == null)
            return false;
        if (other.getCwes() != null && other.getCwes().equals(this.getCwes()) == false)
            return false;
        if (other.getDetectorId() == null ^ this.getDetectorId() == null)
            return false;
        if (other.getDetectorId() != null && other.getDetectorId().equals(this.getDetectorId()) == false)
            return false;
        if (other.getDetectorName() == null ^ this.getDetectorName() == null)
            return false;
        if (other.getDetectorName() != null && other.getDetectorName().equals(this.getDetectorName()) == false)
            return false;
        if (other.getDetectorTags() == null ^ this.getDetectorTags() == null)
            return false;
        if (other.getDetectorTags() != null && other.getDetectorTags().equals(this.getDetectorTags()) == false)
            return false;
        if (other.getFilePath() == null ^ this.getFilePath() == null)
            return false;
        if (other.getFilePath() != null && other.getFilePath().equals(this.getFilePath()) == false)
            return false;
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null)
            return false;
        if (other.getReferenceUrls() != null && other.getReferenceUrls().equals(this.getReferenceUrls()) == false)
            return false;
        if (other.getRuleId() == null ^ this.getRuleId() == null)
            return false;
        if (other.getRuleId() != null && other.getRuleId().equals(this.getRuleId()) == false)
            return false;
        if (other.getSourceLambdaLayerArn() == null ^ this.getSourceLambdaLayerArn() == null)
            return false;
        if (other.getSourceLambdaLayerArn() != null && other.getSourceLambdaLayerArn().equals(this.getSourceLambdaLayerArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCwes() == null) ? 0 : getCwes().hashCode());
        hashCode = prime * hashCode + ((getDetectorId() == null) ? 0 : getDetectorId().hashCode());
        hashCode = prime * hashCode + ((getDetectorName() == null) ? 0 : getDetectorName().hashCode());
        hashCode = prime * hashCode + ((getDetectorTags() == null) ? 0 : getDetectorTags().hashCode());
        hashCode = prime * hashCode + ((getFilePath() == null) ? 0 : getFilePath().hashCode());
        hashCode = prime * hashCode + ((getReferenceUrls() == null) ? 0 : getReferenceUrls().hashCode());
        hashCode = prime * hashCode + ((getRuleId() == null) ? 0 : getRuleId().hashCode());
        hashCode = prime * hashCode + ((getSourceLambdaLayerArn() == null) ? 0 : getSourceLambdaLayerArn().hashCode());
        return hashCode;
    }

    @Override
    public CodeVulnerabilityDetails clone() {
        try {
            return (CodeVulnerabilityDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.inspector2.model.transform.CodeVulnerabilityDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
