/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.LambdaFunctionSortBy;
import com.amazonaws.services.inspector2.model.MapFilter;
import com.amazonaws.services.inspector2.model.SortOrder;
import com.amazonaws.services.inspector2.model.StringFilter;
import com.amazonaws.services.inspector2.model.transform.LambdaFunctionAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LambdaFunctionAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StringFilter> functionNames;
    private List<MapFilter> functionTags;
    private List<StringFilter> resourceIds;
    private List<StringFilter> runtimes;
    private String sortBy;
    private String sortOrder;

    public List<StringFilter> getFunctionNames() {
        return this.functionNames;
    }

    public void setFunctionNames(Collection<StringFilter> functionNames) {
        if (functionNames == null) {
            this.functionNames = null;
            return;
        }
        this.functionNames = new ArrayList<StringFilter>(functionNames);
    }

    public LambdaFunctionAggregation withFunctionNames(StringFilter ... functionNames) {
        if (this.functionNames == null) {
            this.setFunctionNames(new ArrayList<StringFilter>(functionNames.length));
        }
        for (StringFilter ele : functionNames) {
            this.functionNames.add(ele);
        }
        return this;
    }

    public LambdaFunctionAggregation withFunctionNames(Collection<StringFilter> functionNames) {
        this.setFunctionNames(functionNames);
        return this;
    }

    public List<MapFilter> getFunctionTags() {
        return this.functionTags;
    }

    public void setFunctionTags(Collection<MapFilter> functionTags) {
        if (functionTags == null) {
            this.functionTags = null;
            return;
        }
        this.functionTags = new ArrayList<MapFilter>(functionTags);
    }

    public LambdaFunctionAggregation withFunctionTags(MapFilter ... functionTags) {
        if (this.functionTags == null) {
            this.setFunctionTags(new ArrayList<MapFilter>(functionTags.length));
        }
        for (MapFilter ele : functionTags) {
            this.functionTags.add(ele);
        }
        return this;
    }

    public LambdaFunctionAggregation withFunctionTags(Collection<MapFilter> functionTags) {
        this.setFunctionTags(functionTags);
        return this;
    }

    public List<StringFilter> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<StringFilter> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new ArrayList<StringFilter>(resourceIds);
    }

    public LambdaFunctionAggregation withResourceIds(StringFilter ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds(new ArrayList<StringFilter>(resourceIds.length));
        }
        for (StringFilter ele : resourceIds) {
            this.resourceIds.add(ele);
        }
        return this;
    }

    public LambdaFunctionAggregation withResourceIds(Collection<StringFilter> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public List<StringFilter> getRuntimes() {
        return this.runtimes;
    }

    public void setRuntimes(Collection<StringFilter> runtimes) {
        if (runtimes == null) {
            this.runtimes = null;
            return;
        }
        this.runtimes = new ArrayList<StringFilter>(runtimes);
    }

    public LambdaFunctionAggregation withRuntimes(StringFilter ... runtimes) {
        if (this.runtimes == null) {
            this.setRuntimes(new ArrayList<StringFilter>(runtimes.length));
        }
        for (StringFilter ele : runtimes) {
            this.runtimes.add(ele);
        }
        return this;
    }

    public LambdaFunctionAggregation withRuntimes(Collection<StringFilter> runtimes) {
        this.setRuntimes(runtimes);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public LambdaFunctionAggregation withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public LambdaFunctionAggregation withSortBy(LambdaFunctionSortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public LambdaFunctionAggregation withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public LambdaFunctionAggregation withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionNames() != null) {
            sb.append("FunctionNames: ").append(this.getFunctionNames()).append(",");
        }
        if (this.getFunctionTags() != null) {
            sb.append("FunctionTags: ").append(this.getFunctionTags()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds()).append(",");
        }
        if (this.getRuntimes() != null) {
            sb.append("Runtimes: ").append(this.getRuntimes()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAggregation)) {
            return false;
        }
        LambdaFunctionAggregation other = (LambdaFunctionAggregation)obj;
        if (other.getFunctionNames() == null ^ this.getFunctionNames() == null) {
            return false;
        }
        if (other.getFunctionNames() != null && !other.getFunctionNames().equals(this.getFunctionNames())) {
            return false;
        }
        if (other.getFunctionTags() == null ^ this.getFunctionTags() == null) {
            return false;
        }
        if (other.getFunctionTags() != null && !other.getFunctionTags().equals(this.getFunctionTags())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getRuntimes() == null ^ this.getRuntimes() == null) {
            return false;
        }
        if (other.getRuntimes() != null && !other.getRuntimes().equals(this.getRuntimes())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionNames() == null ? 0 : this.getFunctionNames().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionTags() == null ? 0 : this.getFunctionTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimes() == null ? 0 : this.getRuntimes().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public LambdaFunctionAggregation clone() {
        try {
            return (LambdaFunctionAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

