/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.inspector2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CodeVulnerabilityDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CodeVulnerabilityDetailsMarshaller {

    private static final MarshallingInfo<List> CWES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cwes").build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorId").build();
    private static final MarshallingInfo<String> DETECTORNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorName").build();
    private static final MarshallingInfo<List> DETECTORTAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("detectorTags").build();
    private static final MarshallingInfo<StructuredPojo> FILEPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePath").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("referenceUrls").build();
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ruleId").build();
    private static final MarshallingInfo<String> SOURCELAMBDALAYERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceLambdaLayerArn").build();

    private static final CodeVulnerabilityDetailsMarshaller instance = new CodeVulnerabilityDetailsMarshaller();

    public static CodeVulnerabilityDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CodeVulnerabilityDetails codeVulnerabilityDetails, ProtocolMarshaller protocolMarshaller) {

        if (codeVulnerabilityDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(codeVulnerabilityDetails.getCwes(), CWES_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getDetectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getDetectorName(), DETECTORNAME_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getDetectorTags(), DETECTORTAGS_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getRuleId(), RULEID_BINDING);
            protocolMarshaller.marshall(codeVulnerabilityDetails.getSourceLambdaLayerArn(), SOURCELAMBDALAYERARN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
