/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.transform.AtigDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AtigData
implements Serializable,
Cloneable,
StructuredPojo {
    private Date firstSeen;
    private Date lastSeen;
    private List<String> targets;
    private List<String> ttps;

    public void setFirstSeen(Date firstSeen) {
        this.firstSeen = firstSeen;
    }

    public Date getFirstSeen() {
        return this.firstSeen;
    }

    public AtigData withFirstSeen(Date firstSeen) {
        this.setFirstSeen(firstSeen);
        return this;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public AtigData withLastSeen(Date lastSeen) {
        this.setLastSeen(lastSeen);
        return this;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public AtigData withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public AtigData withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public List<String> getTtps() {
        return this.ttps;
    }

    public void setTtps(Collection<String> ttps) {
        if (ttps == null) {
            this.ttps = null;
            return;
        }
        this.ttps = new ArrayList<String>(ttps);
    }

    public AtigData withTtps(String ... ttps) {
        if (this.ttps == null) {
            this.setTtps(new ArrayList<String>(ttps.length));
        }
        for (String ele : ttps) {
            this.ttps.add(ele);
        }
        return this;
    }

    public AtigData withTtps(Collection<String> ttps) {
        this.setTtps(ttps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFirstSeen() != null) {
            sb.append("FirstSeen: ").append(this.getFirstSeen()).append(",");
        }
        if (this.getLastSeen() != null) {
            sb.append("LastSeen: ").append(this.getLastSeen()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTtps() != null) {
            sb.append("Ttps: ").append(this.getTtps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtigData)) {
            return false;
        }
        AtigData other = (AtigData)obj;
        if (other.getFirstSeen() == null ^ this.getFirstSeen() == null) {
            return false;
        }
        if (other.getFirstSeen() != null && !other.getFirstSeen().equals(this.getFirstSeen())) {
            return false;
        }
        if (other.getLastSeen() == null ^ this.getLastSeen() == null) {
            return false;
        }
        if (other.getLastSeen() != null && !other.getLastSeen().equals(this.getLastSeen())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTtps() == null ^ this.getTtps() == null) {
            return false;
        }
        return other.getTtps() == null || other.getTtps().equals(this.getTtps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFirstSeen() == null ? 0 : this.getFirstSeen().hashCode());
        hashCode = 31 * hashCode + (this.getLastSeen() == null ? 0 : this.getLastSeen().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTtps() == null ? 0 : this.getTtps().hashCode());
        return hashCode;
    }

    public AtigData clone() {
        try {
            return (AtigData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AtigDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

