/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.inspector2.model.CisSessionMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendCisSessionTelemetryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<CisSessionMessage> messages;
    private String scanJobId;
    private String sessionToken;

    public List<CisSessionMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<CisSessionMessage> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<CisSessionMessage>(messages);
    }

    public SendCisSessionTelemetryRequest withMessages(CisSessionMessage ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<CisSessionMessage>(messages.length));
        }
        for (CisSessionMessage ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public SendCisSessionTelemetryRequest withMessages(Collection<CisSessionMessage> messages) {
        this.setMessages(messages);
        return this;
    }

    public void setScanJobId(String scanJobId) {
        this.scanJobId = scanJobId;
    }

    public String getScanJobId() {
        return this.scanJobId;
    }

    public SendCisSessionTelemetryRequest withScanJobId(String scanJobId) {
        this.setScanJobId(scanJobId);
        return this;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public SendCisSessionTelemetryRequest withSessionToken(String sessionToken) {
        this.setSessionToken(sessionToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getScanJobId() != null) {
            sb.append("ScanJobId: ").append(this.getScanJobId()).append(",");
        }
        if (this.getSessionToken() != null) {
            sb.append("SessionToken: ").append(this.getSessionToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCisSessionTelemetryRequest)) {
            return false;
        }
        SendCisSessionTelemetryRequest other = (SendCisSessionTelemetryRequest)obj;
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getScanJobId() == null ^ this.getScanJobId() == null) {
            return false;
        }
        if (other.getScanJobId() != null && !other.getScanJobId().equals(this.getScanJobId())) {
            return false;
        }
        if (other.getSessionToken() == null ^ this.getSessionToken() == null) {
            return false;
        }
        return other.getSessionToken() == null || other.getSessionToken().equals(this.getSessionToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getScanJobId() == null ? 0 : this.getScanJobId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionToken() == null ? 0 : this.getSessionToken().hashCode());
        return hashCode;
    }

    public SendCisSessionTelemetryRequest clone() {
        return (SendCisSessionTelemetryRequest)super.clone();
    }
}

