/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Day;
import com.amazonaws.services.inspector2.model.Time;
import com.amazonaws.services.inspector2.model.transform.WeeklyScheduleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WeeklySchedule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> days;
    private Time startTime;

    public List<String> getDays() {
        return this.days;
    }

    public void setDays(Collection<String> days) {
        if (days == null) {
            this.days = null;
            return;
        }
        this.days = new ArrayList<String>(days);
    }

    public WeeklySchedule withDays(String ... days) {
        if (this.days == null) {
            this.setDays(new ArrayList<String>(days.length));
        }
        for (String ele : days) {
            this.days.add(ele);
        }
        return this;
    }

    public WeeklySchedule withDays(Collection<String> days) {
        this.setDays(days);
        return this;
    }

    public WeeklySchedule withDays(Day ... days) {
        ArrayList<String> daysCopy = new ArrayList<String>(days.length);
        for (Day value : days) {
            daysCopy.add(value.toString());
        }
        if (this.getDays() == null) {
            this.setDays(daysCopy);
        } else {
            this.getDays().addAll(daysCopy);
        }
        return this;
    }

    public void setStartTime(Time startTime) {
        this.startTime = startTime;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public WeeklySchedule withStartTime(Time startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDays() != null) {
            sb.append("Days: ").append(this.getDays()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySchedule)) {
            return false;
        }
        WeeklySchedule other = (WeeklySchedule)obj;
        if (other.getDays() == null ^ this.getDays() == null) {
            return false;
        }
        if (other.getDays() != null && !other.getDays().equals(this.getDays())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        return other.getStartTime() == null || other.getStartTime().equals(this.getStartTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDays() == null ? 0 : this.getDays().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        return hashCode;
    }

    public WeeklySchedule clone() {
        try {
            return (WeeklySchedule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WeeklyScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

