/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.CisTargetStatus;
import com.amazonaws.services.inspector2.model.CisTargetStatusReason;
import com.amazonaws.services.inspector2.model.StatusCounts;
import com.amazonaws.services.inspector2.model.transform.CisTargetResourceAggregationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CisTargetResourceAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String platform;
    private String scanArn;
    private StatusCounts statusCounts;
    private String targetResourceId;
    private Map<String, List<String>> targetResourceTags;
    private String targetStatus;
    private String targetStatusReason;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CisTargetResourceAggregation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public CisTargetResourceAggregation withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setScanArn(String scanArn) {
        this.scanArn = scanArn;
    }

    public String getScanArn() {
        return this.scanArn;
    }

    public CisTargetResourceAggregation withScanArn(String scanArn) {
        this.setScanArn(scanArn);
        return this;
    }

    public void setStatusCounts(StatusCounts statusCounts) {
        this.statusCounts = statusCounts;
    }

    public StatusCounts getStatusCounts() {
        return this.statusCounts;
    }

    public CisTargetResourceAggregation withStatusCounts(StatusCounts statusCounts) {
        this.setStatusCounts(statusCounts);
        return this;
    }

    public void setTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public CisTargetResourceAggregation withTargetResourceId(String targetResourceId) {
        this.setTargetResourceId(targetResourceId);
        return this;
    }

    public Map<String, List<String>> getTargetResourceTags() {
        return this.targetResourceTags;
    }

    public void setTargetResourceTags(Map<String, List<String>> targetResourceTags) {
        this.targetResourceTags = targetResourceTags;
    }

    public CisTargetResourceAggregation withTargetResourceTags(Map<String, List<String>> targetResourceTags) {
        this.setTargetResourceTags(targetResourceTags);
        return this;
    }

    public CisTargetResourceAggregation addTargetResourceTagsEntry(String key, List<String> value) {
        if (null == this.targetResourceTags) {
            this.targetResourceTags = new HashMap<String, List<String>>();
        }
        if (this.targetResourceTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targetResourceTags.put(key, value);
        return this;
    }

    public CisTargetResourceAggregation clearTargetResourceTagsEntries() {
        this.targetResourceTags = null;
        return this;
    }

    public void setTargetStatus(String targetStatus) {
        this.targetStatus = targetStatus;
    }

    public String getTargetStatus() {
        return this.targetStatus;
    }

    public CisTargetResourceAggregation withTargetStatus(String targetStatus) {
        this.setTargetStatus(targetStatus);
        return this;
    }

    public CisTargetResourceAggregation withTargetStatus(CisTargetStatus targetStatus) {
        this.targetStatus = targetStatus.toString();
        return this;
    }

    public void setTargetStatusReason(String targetStatusReason) {
        this.targetStatusReason = targetStatusReason;
    }

    public String getTargetStatusReason() {
        return this.targetStatusReason;
    }

    public CisTargetResourceAggregation withTargetStatusReason(String targetStatusReason) {
        this.setTargetStatusReason(targetStatusReason);
        return this;
    }

    public CisTargetResourceAggregation withTargetStatusReason(CisTargetStatusReason targetStatusReason) {
        this.targetStatusReason = targetStatusReason.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getScanArn() != null) {
            sb.append("ScanArn: ").append(this.getScanArn()).append(",");
        }
        if (this.getStatusCounts() != null) {
            sb.append("StatusCounts: ").append(this.getStatusCounts()).append(",");
        }
        if (this.getTargetResourceId() != null) {
            sb.append("TargetResourceId: ").append(this.getTargetResourceId()).append(",");
        }
        if (this.getTargetResourceTags() != null) {
            sb.append("TargetResourceTags: ").append(this.getTargetResourceTags()).append(",");
        }
        if (this.getTargetStatus() != null) {
            sb.append("TargetStatus: ").append(this.getTargetStatus()).append(",");
        }
        if (this.getTargetStatusReason() != null) {
            sb.append("TargetStatusReason: ").append(this.getTargetStatusReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisTargetResourceAggregation)) {
            return false;
        }
        CisTargetResourceAggregation other = (CisTargetResourceAggregation)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getScanArn() == null ^ this.getScanArn() == null) {
            return false;
        }
        if (other.getScanArn() != null && !other.getScanArn().equals(this.getScanArn())) {
            return false;
        }
        if (other.getStatusCounts() == null ^ this.getStatusCounts() == null) {
            return false;
        }
        if (other.getStatusCounts() != null && !other.getStatusCounts().equals(this.getStatusCounts())) {
            return false;
        }
        if (other.getTargetResourceId() == null ^ this.getTargetResourceId() == null) {
            return false;
        }
        if (other.getTargetResourceId() != null && !other.getTargetResourceId().equals(this.getTargetResourceId())) {
            return false;
        }
        if (other.getTargetResourceTags() == null ^ this.getTargetResourceTags() == null) {
            return false;
        }
        if (other.getTargetResourceTags() != null && !other.getTargetResourceTags().equals(this.getTargetResourceTags())) {
            return false;
        }
        if (other.getTargetStatus() == null ^ this.getTargetStatus() == null) {
            return false;
        }
        if (other.getTargetStatus() != null && !other.getTargetStatus().equals(this.getTargetStatus())) {
            return false;
        }
        if (other.getTargetStatusReason() == null ^ this.getTargetStatusReason() == null) {
            return false;
        }
        return other.getTargetStatusReason() == null || other.getTargetStatusReason().equals(this.getTargetStatusReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getScanArn() == null ? 0 : this.getScanArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCounts() == null ? 0 : this.getStatusCounts().hashCode());
        hashCode = 31 * hashCode + (this.getTargetResourceId() == null ? 0 : this.getTargetResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetResourceTags() == null ? 0 : this.getTargetResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getTargetStatus() == null ? 0 : this.getTargetStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTargetStatusReason() == null ? 0 : this.getTargetStatusReason().hashCode());
        return hashCode;
    }

    public CisTargetResourceAggregation clone() {
        try {
            return (CisTargetResourceAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CisTargetResourceAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

