/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot;

import javax.annotation.Generated;

import com.amazonaws.services.iot.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIot}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIot implements AWSIot {

    protected AbstractAWSIot() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptCertificateTransferResult acceptCertificateTransfer(AcceptCertificateTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddThingToBillingGroupResult addThingToBillingGroup(AddThingToBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddThingToThingGroupResult addThingToThingGroup(AddThingToThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTargetsWithJobResult associateTargetsWithJob(AssociateTargetsWithJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachPolicyResult attachPolicy(AttachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AttachPrincipalPolicyResult attachPrincipalPolicy(AttachPrincipalPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachSecurityProfileResult attachSecurityProfile(AttachSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachThingPrincipalResult attachThingPrincipal(AttachThingPrincipalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelAuditTaskResult cancelAuditTask(CancelAuditTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelCertificateTransferResult cancelCertificateTransfer(CancelCertificateTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelJobExecutionResult cancelJobExecution(CancelJobExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ClearDefaultAuthorizerResult clearDefaultAuthorizer(ClearDefaultAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAuthorizerResult createAuthorizer(CreateAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBillingGroupResult createBillingGroup(CreateBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCertificateFromCsrResult createCertificateFromCsr(CreateCertificateFromCsrRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDynamicThingGroupResult createDynamicThingGroup(CreateDynamicThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateKeysAndCertificateResult createKeysAndCertificate(CreateKeysAndCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateOTAUpdateResult createOTAUpdate(CreateOTAUpdateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyResult createPolicy(CreatePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyVersionResult createPolicyVersion(CreatePolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoleAliasResult createRoleAlias(CreateRoleAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateScheduledAuditResult createScheduledAudit(CreateScheduledAuditRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSecurityProfileResult createSecurityProfile(CreateSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStreamResult createStream(CreateStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThingResult createThing(CreateThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThingGroupResult createThingGroup(CreateThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThingTypeResult createThingType(CreateThingTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTopicRuleResult createTopicRule(CreateTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountAuditConfigurationResult deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAuthorizerResult deleteAuthorizer(DeleteAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBillingGroupResult deleteBillingGroup(DeleteBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCACertificateResult deleteCACertificate(DeleteCACertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCertificateResult deleteCertificate(DeleteCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDynamicThingGroupResult deleteDynamicThingGroup(DeleteDynamicThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobExecutionResult deleteJobExecution(DeleteJobExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOTAUpdateResult deleteOTAUpdate(DeleteOTAUpdateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyVersionResult deletePolicyVersion(DeletePolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRegistrationCodeResult deleteRegistrationCode(DeleteRegistrationCodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoleAliasResult deleteRoleAlias(DeleteRoleAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScheduledAuditResult deleteScheduledAudit(DeleteScheduledAuditRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSecurityProfileResult deleteSecurityProfile(DeleteSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStreamResult deleteStream(DeleteStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThingResult deleteThing(DeleteThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThingGroupResult deleteThingGroup(DeleteThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThingTypeResult deleteThingType(DeleteThingTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTopicRuleResult deleteTopicRule(DeleteTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteV2LoggingLevelResult deleteV2LoggingLevel(DeleteV2LoggingLevelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeprecateThingTypeResult deprecateThingType(DeprecateThingTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAuditConfigurationResult describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAuditTaskResult describeAuditTask(DescribeAuditTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAuthorizerResult describeAuthorizer(DescribeAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBillingGroupResult describeBillingGroup(DescribeBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCACertificateResult describeCACertificate(DescribeCACertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCertificateResult describeCertificate(DescribeCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDefaultAuthorizerResult describeDefaultAuthorizer(DescribeDefaultAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointResult describeEndpoint(DescribeEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventConfigurationsResult describeEventConfigurations(DescribeEventConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIndexResult describeIndex(DescribeIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeJobExecutionResult describeJobExecution(DescribeJobExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRoleAliasResult describeRoleAlias(DescribeRoleAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeScheduledAuditResult describeScheduledAudit(DescribeScheduledAuditRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSecurityProfileResult describeSecurityProfile(DescribeSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStreamResult describeStream(DescribeStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThingResult describeThing(DescribeThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThingGroupResult describeThingGroup(DescribeThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThingRegistrationTaskResult describeThingRegistrationTask(DescribeThingRegistrationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThingTypeResult describeThingType(DescribeThingTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachPolicyResult detachPolicy(DetachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public DetachPrincipalPolicyResult detachPrincipalPolicy(DetachPrincipalPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachSecurityProfileResult detachSecurityProfile(DetachSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachThingPrincipalResult detachThingPrincipal(DetachThingPrincipalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableTopicRuleResult disableTopicRule(DisableTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableTopicRuleResult enableTopicRule(EnableTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEffectivePoliciesResult getEffectivePolicies(GetEffectivePoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIndexingConfigurationResult getIndexingConfiguration(GetIndexingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobDocumentResult getJobDocument(GetJobDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLoggingOptionsResult getLoggingOptions(GetLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOTAUpdateResult getOTAUpdate(GetOTAUpdateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyVersionResult getPolicyVersion(GetPolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRegistrationCodeResult getRegistrationCode(GetRegistrationCodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTopicRuleResult getTopicRule(GetTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetV2LoggingOptionsResult getV2LoggingOptions(GetV2LoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListActiveViolationsResult listActiveViolations(ListActiveViolationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttachedPoliciesResult listAttachedPolicies(ListAttachedPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAuditFindingsResult listAuditFindings(ListAuditFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAuditTasksResult listAuditTasks(ListAuditTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAuthorizersResult listAuthorizers(ListAuthorizersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBillingGroupsResult listBillingGroups(ListBillingGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCACertificatesResult listCACertificates(ListCACertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCertificatesResult listCertificates(ListCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCertificatesByCAResult listCertificatesByCA(ListCertificatesByCARequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIndicesResult listIndices(ListIndicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobExecutionsForJobResult listJobExecutionsForJob(ListJobExecutionsForJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobExecutionsForThingResult listJobExecutionsForThing(ListJobExecutionsForThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOTAUpdatesResult listOTAUpdates(ListOTAUpdatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOutgoingCertificatesResult listOutgoingCertificates(ListOutgoingCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPoliciesResult listPolicies(ListPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ListPolicyPrincipalsResult listPolicyPrincipals(ListPolicyPrincipalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPolicyVersionsResult listPolicyVersions(ListPolicyVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ListPrincipalPoliciesResult listPrincipalPolicies(ListPrincipalPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPrincipalThingsResult listPrincipalThings(ListPrincipalThingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoleAliasesResult listRoleAliases(ListRoleAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListScheduledAuditsResult listScheduledAudits(ListScheduledAuditsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSecurityProfilesResult listSecurityProfiles(ListSecurityProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSecurityProfilesForTargetResult listSecurityProfilesForTarget(ListSecurityProfilesForTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetsForPolicyResult listTargetsForPolicy(ListTargetsForPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetsForSecurityProfileResult listTargetsForSecurityProfile(ListTargetsForSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingGroupsResult listThingGroups(ListThingGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingGroupsForThingResult listThingGroupsForThing(ListThingGroupsForThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingPrincipalsResult listThingPrincipals(ListThingPrincipalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingRegistrationTaskReportsResult listThingRegistrationTaskReports(ListThingRegistrationTaskReportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingRegistrationTasksResult listThingRegistrationTasks(ListThingRegistrationTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingTypesResult listThingTypes(ListThingTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingsResult listThings(ListThingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingsInBillingGroupResult listThingsInBillingGroup(ListThingsInBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThingsInThingGroupResult listThingsInThingGroup(ListThingsInThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTopicRulesResult listTopicRules(ListTopicRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListV2LoggingLevelsResult listV2LoggingLevels(ListV2LoggingLevelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListViolationEventsResult listViolationEvents(ListViolationEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterCACertificateResult registerCACertificate(RegisterCACertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterCertificateResult registerCertificate(RegisterCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterThingResult registerThing(RegisterThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectCertificateTransferResult rejectCertificateTransfer(RejectCertificateTransferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveThingFromBillingGroupResult removeThingFromBillingGroup(RemoveThingFromBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveThingFromThingGroupResult removeThingFromThingGroup(RemoveThingFromThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ReplaceTopicRuleResult replaceTopicRule(ReplaceTopicRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchIndexResult searchIndex(SearchIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetDefaultAuthorizerResult setDefaultAuthorizer(SetDefaultAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetDefaultPolicyVersionResult setDefaultPolicyVersion(SetDefaultPolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetLoggingOptionsResult setLoggingOptions(SetLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetV2LoggingLevelResult setV2LoggingLevel(SetV2LoggingLevelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetV2LoggingOptionsResult setV2LoggingOptions(SetV2LoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartOnDemandAuditTaskResult startOnDemandAuditTask(StartOnDemandAuditTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartThingRegistrationTaskResult startThingRegistrationTask(StartThingRegistrationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopThingRegistrationTaskResult stopThingRegistrationTask(StopThingRegistrationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestAuthorizationResult testAuthorization(TestAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestInvokeAuthorizerResult testInvokeAuthorizer(TestInvokeAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TransferCertificateResult transferCertificate(TransferCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountAuditConfigurationResult updateAccountAuditConfiguration(UpdateAccountAuditConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAuthorizerResult updateAuthorizer(UpdateAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBillingGroupResult updateBillingGroup(UpdateBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCACertificateResult updateCACertificate(UpdateCACertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCertificateResult updateCertificate(UpdateCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDynamicThingGroupResult updateDynamicThingGroup(UpdateDynamicThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEventConfigurationsResult updateEventConfigurations(UpdateEventConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIndexingConfigurationResult updateIndexingConfiguration(UpdateIndexingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateJobResult updateJob(UpdateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoleAliasResult updateRoleAlias(UpdateRoleAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateScheduledAuditResult updateScheduledAudit(UpdateScheduledAuditRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityProfileResult updateSecurityProfile(UpdateSecurityProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStreamResult updateStream(UpdateStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThingResult updateThing(UpdateThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThingGroupResult updateThingGroup(UpdateThingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThingGroupsForThingResult updateThingGroupsForThing(UpdateThingGroupsForThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ValidateSecurityProfileBehaviorsResult validateSecurityProfileBehaviors(ValidateSecurityProfileBehaviorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
