/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.AuthResult;
import java.util.List;

@SdkInternalApi
public class AuthResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUTHINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authInfo").build();
    private static final MarshallingInfo<StructuredPojo> ALLOWED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowed").build();
    private static final MarshallingInfo<StructuredPojo> DENIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denied").build();
    private static final MarshallingInfo<String> AUTHDECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authDecision").build();
    private static final MarshallingInfo<List> MISSINGCONTEXTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missingContextValues").build();
    private static final AuthResultMarshaller instance = new AuthResultMarshaller();

    public static AuthResultMarshaller getInstance() {
        return instance;
    }

    public void marshall(AuthResult authResult, ProtocolMarshaller protocolMarshaller) {
        if (authResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)authResult.getAuthInfo(), AUTHINFO_BINDING);
            protocolMarshaller.marshall((Object)authResult.getAllowed(), ALLOWED_BINDING);
            protocolMarshaller.marshall((Object)authResult.getDenied(), DENIED_BINDING);
            protocolMarshaller.marshall((Object)authResult.getAuthDecision(), AUTHDECISION_BINDING);
            protocolMarshaller.marshall(authResult.getMissingContextValues(), MISSINGCONTEXTVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

