/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AuthInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TestAuthorizationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String principal;
    private String cognitoIdentityPoolId;
    private List<AuthInfo> authInfos;
    private String clientId;
    private List<String> policyNamesToAdd;
    private List<String> policyNamesToSkip;

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public TestAuthorizationRequest withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
        this.cognitoIdentityPoolId = cognitoIdentityPoolId;
    }

    public String getCognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public TestAuthorizationRequest withCognitoIdentityPoolId(String cognitoIdentityPoolId) {
        this.setCognitoIdentityPoolId(cognitoIdentityPoolId);
        return this;
    }

    public List<AuthInfo> getAuthInfos() {
        return this.authInfos;
    }

    public void setAuthInfos(Collection<AuthInfo> authInfos) {
        if (authInfos == null) {
            this.authInfos = null;
            return;
        }
        this.authInfos = new ArrayList<AuthInfo>(authInfos);
    }

    public TestAuthorizationRequest withAuthInfos(AuthInfo ... authInfos) {
        if (this.authInfos == null) {
            this.setAuthInfos(new ArrayList<AuthInfo>(authInfos.length));
        }
        for (AuthInfo ele : authInfos) {
            this.authInfos.add(ele);
        }
        return this;
    }

    public TestAuthorizationRequest withAuthInfos(Collection<AuthInfo> authInfos) {
        this.setAuthInfos(authInfos);
        return this;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public TestAuthorizationRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public List<String> getPolicyNamesToAdd() {
        return this.policyNamesToAdd;
    }

    public void setPolicyNamesToAdd(Collection<String> policyNamesToAdd) {
        if (policyNamesToAdd == null) {
            this.policyNamesToAdd = null;
            return;
        }
        this.policyNamesToAdd = new ArrayList<String>(policyNamesToAdd);
    }

    public TestAuthorizationRequest withPolicyNamesToAdd(String ... policyNamesToAdd) {
        if (this.policyNamesToAdd == null) {
            this.setPolicyNamesToAdd(new ArrayList<String>(policyNamesToAdd.length));
        }
        for (String ele : policyNamesToAdd) {
            this.policyNamesToAdd.add(ele);
        }
        return this;
    }

    public TestAuthorizationRequest withPolicyNamesToAdd(Collection<String> policyNamesToAdd) {
        this.setPolicyNamesToAdd(policyNamesToAdd);
        return this;
    }

    public List<String> getPolicyNamesToSkip() {
        return this.policyNamesToSkip;
    }

    public void setPolicyNamesToSkip(Collection<String> policyNamesToSkip) {
        if (policyNamesToSkip == null) {
            this.policyNamesToSkip = null;
            return;
        }
        this.policyNamesToSkip = new ArrayList<String>(policyNamesToSkip);
    }

    public TestAuthorizationRequest withPolicyNamesToSkip(String ... policyNamesToSkip) {
        if (this.policyNamesToSkip == null) {
            this.setPolicyNamesToSkip(new ArrayList<String>(policyNamesToSkip.length));
        }
        for (String ele : policyNamesToSkip) {
            this.policyNamesToSkip.add(ele);
        }
        return this;
    }

    public TestAuthorizationRequest withPolicyNamesToSkip(Collection<String> policyNamesToSkip) {
        this.setPolicyNamesToSkip(policyNamesToSkip);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getCognitoIdentityPoolId() != null) {
            sb.append("CognitoIdentityPoolId: ").append(this.getCognitoIdentityPoolId()).append(",");
        }
        if (this.getAuthInfos() != null) {
            sb.append("AuthInfos: ").append(this.getAuthInfos()).append(",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getPolicyNamesToAdd() != null) {
            sb.append("PolicyNamesToAdd: ").append(this.getPolicyNamesToAdd()).append(",");
        }
        if (this.getPolicyNamesToSkip() != null) {
            sb.append("PolicyNamesToSkip: ").append(this.getPolicyNamesToSkip());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationRequest)) {
            return false;
        }
        TestAuthorizationRequest other = (TestAuthorizationRequest)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getCognitoIdentityPoolId() == null ^ this.getCognitoIdentityPoolId() == null) {
            return false;
        }
        if (other.getCognitoIdentityPoolId() != null && !other.getCognitoIdentityPoolId().equals(this.getCognitoIdentityPoolId())) {
            return false;
        }
        if (other.getAuthInfos() == null ^ this.getAuthInfos() == null) {
            return false;
        }
        if (other.getAuthInfos() != null && !other.getAuthInfos().equals(this.getAuthInfos())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getPolicyNamesToAdd() == null ^ this.getPolicyNamesToAdd() == null) {
            return false;
        }
        if (other.getPolicyNamesToAdd() != null && !other.getPolicyNamesToAdd().equals(this.getPolicyNamesToAdd())) {
            return false;
        }
        if (other.getPolicyNamesToSkip() == null ^ this.getPolicyNamesToSkip() == null) {
            return false;
        }
        return other.getPolicyNamesToSkip() == null || other.getPolicyNamesToSkip().equals(this.getPolicyNamesToSkip());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getCognitoIdentityPoolId() == null ? 0 : this.getCognitoIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getAuthInfos() == null ? 0 : this.getAuthInfos().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyNamesToAdd() == null ? 0 : this.getPolicyNamesToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyNamesToSkip() == null ? 0 : this.getPolicyNamesToSkip().hashCode());
        return hashCode;
    }

    public TestAuthorizationRequest clone() {
        return (TestAuthorizationRequest)super.clone();
    }
}

