/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.AlertTarget;
import com.amazonaws.services.iot.model.Behavior;
import com.amazonaws.services.iot.model.MetricToRetain;
import com.amazonaws.services.iot.model.MetricsExportConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSecurityProfileResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String securityProfileName;
    private String securityProfileArn;
    private String securityProfileDescription;
    private List<Behavior> behaviors;
    private Map<String, AlertTarget> alertTargets;
    @Deprecated
    private List<String> additionalMetricsToRetain;
    private List<MetricToRetain> additionalMetricsToRetainV2;
    private Long version;
    private Date creationDate;
    private Date lastModifiedDate;
    private MetricsExportConfig metricsExportConfig;

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public UpdateSecurityProfileResult withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setSecurityProfileArn(String securityProfileArn) {
        this.securityProfileArn = securityProfileArn;
    }

    public String getSecurityProfileArn() {
        return this.securityProfileArn;
    }

    public UpdateSecurityProfileResult withSecurityProfileArn(String securityProfileArn) {
        this.setSecurityProfileArn(securityProfileArn);
        return this;
    }

    public void setSecurityProfileDescription(String securityProfileDescription) {
        this.securityProfileDescription = securityProfileDescription;
    }

    public String getSecurityProfileDescription() {
        return this.securityProfileDescription;
    }

    public UpdateSecurityProfileResult withSecurityProfileDescription(String securityProfileDescription) {
        this.setSecurityProfileDescription(securityProfileDescription);
        return this;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(Collection<Behavior> behaviors) {
        if (behaviors == null) {
            this.behaviors = null;
            return;
        }
        this.behaviors = new ArrayList<Behavior>(behaviors);
    }

    public UpdateSecurityProfileResult withBehaviors(Behavior ... behaviors) {
        if (this.behaviors == null) {
            this.setBehaviors(new ArrayList<Behavior>(behaviors.length));
        }
        for (Behavior ele : behaviors) {
            this.behaviors.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileResult withBehaviors(Collection<Behavior> behaviors) {
        this.setBehaviors(behaviors);
        return this;
    }

    public Map<String, AlertTarget> getAlertTargets() {
        return this.alertTargets;
    }

    public void setAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.alertTargets = alertTargets;
    }

    public UpdateSecurityProfileResult withAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.setAlertTargets(alertTargets);
        return this;
    }

    public UpdateSecurityProfileResult addAlertTargetsEntry(String key, AlertTarget value) {
        if (null == this.alertTargets) {
            this.alertTargets = new HashMap<String, AlertTarget>();
        }
        if (this.alertTargets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.alertTargets.put(key, value);
        return this;
    }

    public UpdateSecurityProfileResult clearAlertTargetsEntries() {
        this.alertTargets = null;
        return this;
    }

    @Deprecated
    public List<String> getAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    @Deprecated
    public void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        if (additionalMetricsToRetain == null) {
            this.additionalMetricsToRetain = null;
            return;
        }
        this.additionalMetricsToRetain = new ArrayList<String>(additionalMetricsToRetain);
    }

    @Deprecated
    public UpdateSecurityProfileResult withAdditionalMetricsToRetain(String ... additionalMetricsToRetain) {
        if (this.additionalMetricsToRetain == null) {
            this.setAdditionalMetricsToRetain(new ArrayList<String>(additionalMetricsToRetain.length));
        }
        for (String ele : additionalMetricsToRetain) {
            this.additionalMetricsToRetain.add(ele);
        }
        return this;
    }

    @Deprecated
    public UpdateSecurityProfileResult withAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        this.setAdditionalMetricsToRetain(additionalMetricsToRetain);
        return this;
    }

    public List<MetricToRetain> getAdditionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2;
    }

    public void setAdditionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
        if (additionalMetricsToRetainV2 == null) {
            this.additionalMetricsToRetainV2 = null;
            return;
        }
        this.additionalMetricsToRetainV2 = new ArrayList<MetricToRetain>(additionalMetricsToRetainV2);
    }

    public UpdateSecurityProfileResult withAdditionalMetricsToRetainV2(MetricToRetain ... additionalMetricsToRetainV2) {
        if (this.additionalMetricsToRetainV2 == null) {
            this.setAdditionalMetricsToRetainV2(new ArrayList<MetricToRetain>(additionalMetricsToRetainV2.length));
        }
        for (MetricToRetain ele : additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileResult withAdditionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
        this.setAdditionalMetricsToRetainV2(additionalMetricsToRetainV2);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public UpdateSecurityProfileResult withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public UpdateSecurityProfileResult withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public UpdateSecurityProfileResult withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setMetricsExportConfig(MetricsExportConfig metricsExportConfig) {
        this.metricsExportConfig = metricsExportConfig;
    }

    public MetricsExportConfig getMetricsExportConfig() {
        return this.metricsExportConfig;
    }

    public UpdateSecurityProfileResult withMetricsExportConfig(MetricsExportConfig metricsExportConfig) {
        this.setMetricsExportConfig(metricsExportConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getSecurityProfileArn() != null) {
            sb.append("SecurityProfileArn: ").append(this.getSecurityProfileArn()).append(",");
        }
        if (this.getSecurityProfileDescription() != null) {
            sb.append("SecurityProfileDescription: ").append(this.getSecurityProfileDescription()).append(",");
        }
        if (this.getBehaviors() != null) {
            sb.append("Behaviors: ").append(this.getBehaviors()).append(",");
        }
        if (this.getAlertTargets() != null) {
            sb.append("AlertTargets: ").append(this.getAlertTargets()).append(",");
        }
        if (this.getAdditionalMetricsToRetain() != null) {
            sb.append("AdditionalMetricsToRetain: ").append(this.getAdditionalMetricsToRetain()).append(",");
        }
        if (this.getAdditionalMetricsToRetainV2() != null) {
            sb.append("AdditionalMetricsToRetainV2: ").append(this.getAdditionalMetricsToRetainV2()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getMetricsExportConfig() != null) {
            sb.append("MetricsExportConfig: ").append(this.getMetricsExportConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileResult)) {
            return false;
        }
        UpdateSecurityProfileResult other = (UpdateSecurityProfileResult)obj;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getSecurityProfileArn() == null ^ this.getSecurityProfileArn() == null) {
            return false;
        }
        if (other.getSecurityProfileArn() != null && !other.getSecurityProfileArn().equals(this.getSecurityProfileArn())) {
            return false;
        }
        if (other.getSecurityProfileDescription() == null ^ this.getSecurityProfileDescription() == null) {
            return false;
        }
        if (other.getSecurityProfileDescription() != null && !other.getSecurityProfileDescription().equals(this.getSecurityProfileDescription())) {
            return false;
        }
        if (other.getBehaviors() == null ^ this.getBehaviors() == null) {
            return false;
        }
        if (other.getBehaviors() != null && !other.getBehaviors().equals(this.getBehaviors())) {
            return false;
        }
        if (other.getAlertTargets() == null ^ this.getAlertTargets() == null) {
            return false;
        }
        if (other.getAlertTargets() != null && !other.getAlertTargets().equals(this.getAlertTargets())) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() == null ^ this.getAdditionalMetricsToRetain() == null) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() != null && !other.getAdditionalMetricsToRetain().equals(this.getAdditionalMetricsToRetain())) {
            return false;
        }
        if (other.getAdditionalMetricsToRetainV2() == null ^ this.getAdditionalMetricsToRetainV2() == null) {
            return false;
        }
        if (other.getAdditionalMetricsToRetainV2() != null && !other.getAdditionalMetricsToRetainV2().equals(this.getAdditionalMetricsToRetainV2())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getMetricsExportConfig() == null ^ this.getMetricsExportConfig() == null) {
            return false;
        }
        return other.getMetricsExportConfig() == null || other.getMetricsExportConfig().equals(this.getMetricsExportConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileArn() == null ? 0 : this.getSecurityProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileDescription() == null ? 0 : this.getSecurityProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBehaviors() == null ? 0 : this.getBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getAlertTargets() == null ? 0 : this.getAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetricsToRetain() == null ? 0 : this.getAdditionalMetricsToRetain().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetricsToRetainV2() == null ? 0 : this.getAdditionalMetricsToRetainV2().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsExportConfig() == null ? 0 : this.getMetricsExportConfig().hashCode());
        return hashCode;
    }

    public UpdateSecurityProfileResult clone() {
        try {
            return (UpdateSecurityProfileResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

