/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.DatasetAction;
import com.amazonaws.services.iotanalytics.model.DatasetContentDeliveryRule;
import com.amazonaws.services.iotanalytics.model.DatasetTrigger;
import com.amazonaws.services.iotanalytics.model.RetentionPeriod;
import com.amazonaws.services.iotanalytics.model.VersioningConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDatasetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String datasetName;
    private List<DatasetAction> actions;
    private List<DatasetTrigger> triggers;
    private List<DatasetContentDeliveryRule> contentDeliveryRules;
    private RetentionPeriod retentionPeriod;
    private VersioningConfiguration versioningConfiguration;

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public UpdateDatasetRequest withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public List<DatasetAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<DatasetAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<DatasetAction>(actions);
    }

    public UpdateDatasetRequest withActions(DatasetAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<DatasetAction>(actions.length));
        }
        for (DatasetAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public UpdateDatasetRequest withActions(Collection<DatasetAction> actions) {
        this.setActions(actions);
        return this;
    }

    public List<DatasetTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<DatasetTrigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        this.triggers = new ArrayList<DatasetTrigger>(triggers);
    }

    public UpdateDatasetRequest withTriggers(DatasetTrigger ... triggers) {
        if (this.triggers == null) {
            this.setTriggers(new ArrayList<DatasetTrigger>(triggers.length));
        }
        for (DatasetTrigger ele : triggers) {
            this.triggers.add(ele);
        }
        return this;
    }

    public UpdateDatasetRequest withTriggers(Collection<DatasetTrigger> triggers) {
        this.setTriggers(triggers);
        return this;
    }

    public List<DatasetContentDeliveryRule> getContentDeliveryRules() {
        return this.contentDeliveryRules;
    }

    public void setContentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
        if (contentDeliveryRules == null) {
            this.contentDeliveryRules = null;
            return;
        }
        this.contentDeliveryRules = new ArrayList<DatasetContentDeliveryRule>(contentDeliveryRules);
    }

    public UpdateDatasetRequest withContentDeliveryRules(DatasetContentDeliveryRule ... contentDeliveryRules) {
        if (this.contentDeliveryRules == null) {
            this.setContentDeliveryRules(new ArrayList<DatasetContentDeliveryRule>(contentDeliveryRules.length));
        }
        for (DatasetContentDeliveryRule ele : contentDeliveryRules) {
            this.contentDeliveryRules.add(ele);
        }
        return this;
    }

    public UpdateDatasetRequest withContentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
        this.setContentDeliveryRules(contentDeliveryRules);
        return this;
    }

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public UpdateDatasetRequest withRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public void setVersioningConfiguration(VersioningConfiguration versioningConfiguration) {
        this.versioningConfiguration = versioningConfiguration;
    }

    public VersioningConfiguration getVersioningConfiguration() {
        return this.versioningConfiguration;
    }

    public UpdateDatasetRequest withVersioningConfiguration(VersioningConfiguration versioningConfiguration) {
        this.setVersioningConfiguration(versioningConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: ").append(this.getTriggers()).append(",");
        }
        if (this.getContentDeliveryRules() != null) {
            sb.append("ContentDeliveryRules: ").append(this.getContentDeliveryRules()).append(",");
        }
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getVersioningConfiguration() != null) {
            sb.append("VersioningConfiguration: ").append(this.getVersioningConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest)obj;
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        if (other.getTriggers() != null && !other.getTriggers().equals(this.getTriggers())) {
            return false;
        }
        if (other.getContentDeliveryRules() == null ^ this.getContentDeliveryRules() == null) {
            return false;
        }
        if (other.getContentDeliveryRules() != null && !other.getContentDeliveryRules().equals(this.getContentDeliveryRules())) {
            return false;
        }
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getVersioningConfiguration() == null ^ this.getVersioningConfiguration() == null) {
            return false;
        }
        return other.getVersioningConfiguration() == null || other.getVersioningConfiguration().equals(this.getVersioningConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : this.getTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getContentDeliveryRules() == null ? 0 : this.getContentDeliveryRules().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getVersioningConfiguration() == null ? 0 : this.getVersioningConfiguration().hashCode());
        return hashCode;
    }

    public UpdateDatasetRequest clone() {
        return (UpdateDatasetRequest)super.clone();
    }
}

