/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.DatasetActionSummary;
import com.amazonaws.services.iotanalytics.model.DatasetStatus;
import com.amazonaws.services.iotanalytics.model.DatasetTrigger;
import com.amazonaws.services.iotanalytics.model.transform.DatasetSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DatasetSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String datasetName;
    private String status;
    private Date creationTime;
    private Date lastUpdateTime;
    private List<DatasetTrigger> triggers;
    private List<DatasetActionSummary> actions;

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public DatasetSummary withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DatasetSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DatasetSummary withStatus(DatasetStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public DatasetSummary withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public DatasetSummary withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public List<DatasetTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<DatasetTrigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        this.triggers = new ArrayList<DatasetTrigger>(triggers);
    }

    public DatasetSummary withTriggers(DatasetTrigger ... triggers) {
        if (this.triggers == null) {
            this.setTriggers(new ArrayList<DatasetTrigger>(triggers.length));
        }
        for (DatasetTrigger ele : triggers) {
            this.triggers.add(ele);
        }
        return this;
    }

    public DatasetSummary withTriggers(Collection<DatasetTrigger> triggers) {
        this.setTriggers(triggers);
        return this;
    }

    public List<DatasetActionSummary> getActions() {
        return this.actions;
    }

    public void setActions(Collection<DatasetActionSummary> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<DatasetActionSummary>(actions);
    }

    public DatasetSummary withActions(DatasetActionSummary ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<DatasetActionSummary>(actions.length));
        }
        for (DatasetActionSummary ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public DatasetSummary withActions(Collection<DatasetActionSummary> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime()).append(",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: ").append(this.getTriggers()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSummary)) {
            return false;
        }
        DatasetSummary other = (DatasetSummary)obj;
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        if (other.getLastUpdateTime() != null && !other.getLastUpdateTime().equals(this.getLastUpdateTime())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        if (other.getTriggers() != null && !other.getTriggers().equals(this.getTriggers())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : this.getTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public DatasetSummary clone() {
        try {
            return (DatasetSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatasetSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

