/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.ChannelMessages;
import java.util.List;

@SdkInternalApi
public class ChannelMessagesMarshaller {
    private static final MarshallingInfo<List> S3PATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Paths").build();
    private static final ChannelMessagesMarshaller instance = new ChannelMessagesMarshaller();

    public static ChannelMessagesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChannelMessages channelMessages, ProtocolMarshaller protocolMarshaller) {
        if (channelMessages == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(channelMessages.getS3Paths(), S3PATHS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

