/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.transform.MessageMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Message
implements Serializable,
Cloneable,
StructuredPojo {
    private String messageId;
    private ByteBuffer payload;

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Message withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public void setPayload(ByteBuffer payload) {
        this.payload = payload;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public Message withPayload(ByteBuffer payload) {
        this.setPayload(payload);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessageId() != null) {
            sb.append("MessageId: ").append(this.getMessageId()).append(",");
        }
        if (this.getPayload() != null) {
            sb.append("Payload: ").append(this.getPayload());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.getMessageId() == null ^ this.getMessageId() == null) {
            return false;
        }
        if (other.getMessageId() != null && !other.getMessageId().equals(this.getMessageId())) {
            return false;
        }
        if (other.getPayload() == null ^ this.getPayload() == null) {
            return false;
        }
        return other.getPayload() == null || other.getPayload().equals(this.getPayload());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessageId() == null ? 0 : this.getMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        return hashCode;
    }

    public Message clone() {
        try {
            return (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

