/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotfleetwise.model.S3Config;

@SdkInternalApi
public class S3ConfigMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketArn").build();
    private static final MarshallingInfo<String> DATAFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataFormat").build();
    private static final MarshallingInfo<String> STORAGECOMPRESSIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageCompressionFormat").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3ConfigMarshaller instance = new S3ConfigMarshaller();

    public static S3ConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Config s3Config, ProtocolMarshaller protocolMarshaller) {
        if (s3Config == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Config.getBucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3Config.getDataFormat(), DATAFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3Config.getStorageCompressionFormat(), STORAGECOMPRESSIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3Config.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

