/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotroborunner;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotroborunner.AWSIoTRoboRunnerAsync;
import com.amazonaws.services.iotroborunner.AWSIoTRoboRunnerAsyncClientBuilder;
import com.amazonaws.services.iotroborunner.AWSIoTRoboRunnerClient;
import com.amazonaws.services.iotroborunner.model.CreateDestinationRequest;
import com.amazonaws.services.iotroborunner.model.CreateDestinationResult;
import com.amazonaws.services.iotroborunner.model.CreateSiteRequest;
import com.amazonaws.services.iotroborunner.model.CreateSiteResult;
import com.amazonaws.services.iotroborunner.model.CreateWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.CreateWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.CreateWorkerRequest;
import com.amazonaws.services.iotroborunner.model.CreateWorkerResult;
import com.amazonaws.services.iotroborunner.model.DeleteDestinationRequest;
import com.amazonaws.services.iotroborunner.model.DeleteDestinationResult;
import com.amazonaws.services.iotroborunner.model.DeleteSiteRequest;
import com.amazonaws.services.iotroborunner.model.DeleteSiteResult;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerRequest;
import com.amazonaws.services.iotroborunner.model.DeleteWorkerResult;
import com.amazonaws.services.iotroborunner.model.GetDestinationRequest;
import com.amazonaws.services.iotroborunner.model.GetDestinationResult;
import com.amazonaws.services.iotroborunner.model.GetSiteRequest;
import com.amazonaws.services.iotroborunner.model.GetSiteResult;
import com.amazonaws.services.iotroborunner.model.GetWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.GetWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.GetWorkerRequest;
import com.amazonaws.services.iotroborunner.model.GetWorkerResult;
import com.amazonaws.services.iotroborunner.model.ListDestinationsRequest;
import com.amazonaws.services.iotroborunner.model.ListDestinationsResult;
import com.amazonaws.services.iotroborunner.model.ListSitesRequest;
import com.amazonaws.services.iotroborunner.model.ListSitesResult;
import com.amazonaws.services.iotroborunner.model.ListWorkerFleetsRequest;
import com.amazonaws.services.iotroborunner.model.ListWorkerFleetsResult;
import com.amazonaws.services.iotroborunner.model.ListWorkersRequest;
import com.amazonaws.services.iotroborunner.model.ListWorkersResult;
import com.amazonaws.services.iotroborunner.model.UpdateDestinationRequest;
import com.amazonaws.services.iotroborunner.model.UpdateDestinationResult;
import com.amazonaws.services.iotroborunner.model.UpdateSiteRequest;
import com.amazonaws.services.iotroborunner.model.UpdateSiteResult;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerFleetRequest;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerFleetResult;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerRequest;
import com.amazonaws.services.iotroborunner.model.UpdateWorkerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTRoboRunnerAsyncClient
extends AWSIoTRoboRunnerClient
implements AWSIoTRoboRunnerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTRoboRunnerAsyncClientBuilder asyncBuilder() {
        return AWSIoTRoboRunnerAsyncClientBuilder.standard();
    }

    AWSIoTRoboRunnerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTRoboRunnerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request) {
        return this.createDestinationAsync(request, null);
    }

    @Override
    public Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request, final AsyncHandler<CreateDestinationRequest, CreateDestinationResult> asyncHandler) {
        final CreateDestinationRequest finalRequest = (CreateDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDestinationResult>(){

            @Override
            public CreateDestinationResult call() throws Exception {
                CreateDestinationResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeCreateDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request) {
        return this.createSiteAsync(request, null);
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request, final AsyncHandler<CreateSiteRequest, CreateSiteResult> asyncHandler) {
        final CreateSiteRequest finalRequest = (CreateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSiteResult>(){

            @Override
            public CreateSiteResult call() throws Exception {
                CreateSiteResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeCreateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request) {
        return this.createWorkerAsync(request, null);
    }

    @Override
    public Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request, final AsyncHandler<CreateWorkerRequest, CreateWorkerResult> asyncHandler) {
        final CreateWorkerRequest finalRequest = (CreateWorkerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkerResult>(){

            @Override
            public CreateWorkerResult call() throws Exception {
                CreateWorkerResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeCreateWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkerFleetResult> createWorkerFleetAsync(CreateWorkerFleetRequest request) {
        return this.createWorkerFleetAsync(request, null);
    }

    @Override
    public Future<CreateWorkerFleetResult> createWorkerFleetAsync(CreateWorkerFleetRequest request, final AsyncHandler<CreateWorkerFleetRequest, CreateWorkerFleetResult> asyncHandler) {
        final CreateWorkerFleetRequest finalRequest = (CreateWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkerFleetResult>(){

            @Override
            public CreateWorkerFleetResult call() throws Exception {
                CreateWorkerFleetResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeCreateWorkerFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request) {
        return this.deleteDestinationAsync(request, null);
    }

    @Override
    public Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request, final AsyncHandler<DeleteDestinationRequest, DeleteDestinationResult> asyncHandler) {
        final DeleteDestinationRequest finalRequest = (DeleteDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDestinationResult>(){

            @Override
            public DeleteDestinationResult call() throws Exception {
                DeleteDestinationResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeDeleteDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request) {
        return this.deleteSiteAsync(request, null);
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request, final AsyncHandler<DeleteSiteRequest, DeleteSiteResult> asyncHandler) {
        final DeleteSiteRequest finalRequest = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSiteResult>(){

            @Override
            public DeleteSiteResult call() throws Exception {
                DeleteSiteResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeDeleteSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request) {
        return this.deleteWorkerAsync(request, null);
    }

    @Override
    public Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request, final AsyncHandler<DeleteWorkerRequest, DeleteWorkerResult> asyncHandler) {
        final DeleteWorkerRequest finalRequest = (DeleteWorkerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkerResult>(){

            @Override
            public DeleteWorkerResult call() throws Exception {
                DeleteWorkerResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeDeleteWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkerFleetResult> deleteWorkerFleetAsync(DeleteWorkerFleetRequest request) {
        return this.deleteWorkerFleetAsync(request, null);
    }

    @Override
    public Future<DeleteWorkerFleetResult> deleteWorkerFleetAsync(DeleteWorkerFleetRequest request, final AsyncHandler<DeleteWorkerFleetRequest, DeleteWorkerFleetResult> asyncHandler) {
        final DeleteWorkerFleetRequest finalRequest = (DeleteWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkerFleetResult>(){

            @Override
            public DeleteWorkerFleetResult call() throws Exception {
                DeleteWorkerFleetResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeDeleteWorkerFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request) {
        return this.getDestinationAsync(request, null);
    }

    @Override
    public Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request, final AsyncHandler<GetDestinationRequest, GetDestinationResult> asyncHandler) {
        final GetDestinationRequest finalRequest = (GetDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDestinationResult>(){

            @Override
            public GetDestinationResult call() throws Exception {
                GetDestinationResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeGetDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSiteResult> getSiteAsync(GetSiteRequest request) {
        return this.getSiteAsync(request, null);
    }

    @Override
    public Future<GetSiteResult> getSiteAsync(GetSiteRequest request, final AsyncHandler<GetSiteRequest, GetSiteResult> asyncHandler) {
        final GetSiteRequest finalRequest = (GetSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSiteResult>(){

            @Override
            public GetSiteResult call() throws Exception {
                GetSiteResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeGetSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request) {
        return this.getWorkerAsync(request, null);
    }

    @Override
    public Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request, final AsyncHandler<GetWorkerRequest, GetWorkerResult> asyncHandler) {
        final GetWorkerRequest finalRequest = (GetWorkerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkerResult>(){

            @Override
            public GetWorkerResult call() throws Exception {
                GetWorkerResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeGetWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkerFleetResult> getWorkerFleetAsync(GetWorkerFleetRequest request) {
        return this.getWorkerFleetAsync(request, null);
    }

    @Override
    public Future<GetWorkerFleetResult> getWorkerFleetAsync(GetWorkerFleetRequest request, final AsyncHandler<GetWorkerFleetRequest, GetWorkerFleetResult> asyncHandler) {
        final GetWorkerFleetRequest finalRequest = (GetWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkerFleetResult>(){

            @Override
            public GetWorkerFleetResult call() throws Exception {
                GetWorkerFleetResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeGetWorkerFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request) {
        return this.listDestinationsAsync(request, null);
    }

    @Override
    public Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request, final AsyncHandler<ListDestinationsRequest, ListDestinationsResult> asyncHandler) {
        final ListDestinationsRequest finalRequest = (ListDestinationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDestinationsResult>(){

            @Override
            public ListDestinationsResult call() throws Exception {
                ListDestinationsResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeListDestinations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request) {
        return this.listSitesAsync(request, null);
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request, final AsyncHandler<ListSitesRequest, ListSitesResult> asyncHandler) {
        final ListSitesRequest finalRequest = (ListSitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSitesResult>(){

            @Override
            public ListSitesResult call() throws Exception {
                ListSitesResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeListSites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkerFleetsResult> listWorkerFleetsAsync(ListWorkerFleetsRequest request) {
        return this.listWorkerFleetsAsync(request, null);
    }

    @Override
    public Future<ListWorkerFleetsResult> listWorkerFleetsAsync(ListWorkerFleetsRequest request, final AsyncHandler<ListWorkerFleetsRequest, ListWorkerFleetsResult> asyncHandler) {
        final ListWorkerFleetsRequest finalRequest = (ListWorkerFleetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkerFleetsResult>(){

            @Override
            public ListWorkerFleetsResult call() throws Exception {
                ListWorkerFleetsResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeListWorkerFleets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request) {
        return this.listWorkersAsync(request, null);
    }

    @Override
    public Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request, final AsyncHandler<ListWorkersRequest, ListWorkersResult> asyncHandler) {
        final ListWorkersRequest finalRequest = (ListWorkersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkersResult>(){

            @Override
            public ListWorkersResult call() throws Exception {
                ListWorkersResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeListWorkers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request) {
        return this.updateDestinationAsync(request, null);
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request, final AsyncHandler<UpdateDestinationRequest, UpdateDestinationResult> asyncHandler) {
        final UpdateDestinationRequest finalRequest = (UpdateDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDestinationResult>(){

            @Override
            public UpdateDestinationResult call() throws Exception {
                UpdateDestinationResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeUpdateDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request) {
        return this.updateSiteAsync(request, null);
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request, final AsyncHandler<UpdateSiteRequest, UpdateSiteResult> asyncHandler) {
        final UpdateSiteRequest finalRequest = (UpdateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSiteResult>(){

            @Override
            public UpdateSiteResult call() throws Exception {
                UpdateSiteResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeUpdateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request) {
        return this.updateWorkerAsync(request, null);
    }

    @Override
    public Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request, final AsyncHandler<UpdateWorkerRequest, UpdateWorkerResult> asyncHandler) {
        final UpdateWorkerRequest finalRequest = (UpdateWorkerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkerResult>(){

            @Override
            public UpdateWorkerResult call() throws Exception {
                UpdateWorkerResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeUpdateWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkerFleetResult> updateWorkerFleetAsync(UpdateWorkerFleetRequest request) {
        return this.updateWorkerFleetAsync(request, null);
    }

    @Override
    public Future<UpdateWorkerFleetResult> updateWorkerFleetAsync(UpdateWorkerFleetRequest request, final AsyncHandler<UpdateWorkerFleetRequest, UpdateWorkerFleetResult> asyncHandler) {
        final UpdateWorkerFleetRequest finalRequest = (UpdateWorkerFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkerFleetResult>(){

            @Override
            public UpdateWorkerFleetResult call() throws Exception {
                UpdateWorkerFleetResult result = null;
                try {
                    result = AWSIoTRoboRunnerAsyncClient.this.executeUpdateWorkerFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

