/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotthingsgraph.model.DefinitionLanguage;
import com.amazonaws.services.iotthingsgraph.model.transform.DefinitionDocumentMarshaller;
import java.io.Serializable;

public class DefinitionDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private String language;
    private String text;

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public DefinitionDocument withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public DefinitionDocument withLanguage(DefinitionLanguage language) {
        this.language = language.toString();
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public DefinitionDocument withText(String text) {
        this.setText(text);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguage() != null) {
            sb.append("Language: ").append(this.getLanguage()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionDocument)) {
            return false;
        }
        DefinitionDocument other = (DefinitionDocument)obj;
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        if (other.getLanguage() != null && !other.getLanguage().equals(this.getLanguage())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        return other.getText() == null || other.getText().equals(this.getText());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        return hashCode;
    }

    public DefinitionDocument clone() {
        try {
            return (DefinitionDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefinitionDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

