/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.Firehose;

@SdkInternalApi
public class FirehoseMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deliveryStream").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final FirehoseMarshaller instance = new FirehoseMarshaller();

    public static FirehoseMarshaller getInstance() {
        return instance;
    }

    public void marshall(Firehose firehose, ProtocolMarshaller protocolMarshaller) {
        if (firehose == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)firehose.getDeliveryStream(), DELIVERYSTREAM_BINDING);
            protocolMarshaller.marshall((Object)firehose.getEnabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

