/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ClientAuthentication;

@SdkInternalApi
public class ClientAuthenticationMarshaller {
    private static final MarshallingInfo<StructuredPojo> SASL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sasl").build();
    private static final MarshallingInfo<StructuredPojo> TLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tls").build();
    private static final MarshallingInfo<StructuredPojo> UNAUTHENTICATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unauthenticated").build();
    private static final ClientAuthenticationMarshaller instance = new ClientAuthenticationMarshaller();

    public static ClientAuthenticationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClientAuthentication clientAuthentication, ProtocolMarshaller protocolMarshaller) {
        if (clientAuthentication == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clientAuthentication.getSasl(), SASL_BINDING);
            protocolMarshaller.marshall((Object)clientAuthentication.getTls(), TLS_BINDING);
            protocolMarshaller.marshall((Object)clientAuthentication.getUnauthenticated(), UNAUTHENTICATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

