/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kafka.model.BrokerEBSVolumeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateBrokerStorageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterArn;
    private String currentVersion;
    private List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo;

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public UpdateBrokerStorageRequest withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public UpdateBrokerStorageRequest withCurrentVersion(String currentVersion) {
        this.setCurrentVersion(currentVersion);
        return this;
    }

    public List<BrokerEBSVolumeInfo> getTargetBrokerEBSVolumeInfo() {
        return this.targetBrokerEBSVolumeInfo;
    }

    public void setTargetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo) {
        if (targetBrokerEBSVolumeInfo == null) {
            this.targetBrokerEBSVolumeInfo = null;
            return;
        }
        this.targetBrokerEBSVolumeInfo = new ArrayList<BrokerEBSVolumeInfo>(targetBrokerEBSVolumeInfo);
    }

    public UpdateBrokerStorageRequest withTargetBrokerEBSVolumeInfo(BrokerEBSVolumeInfo ... targetBrokerEBSVolumeInfo) {
        if (this.targetBrokerEBSVolumeInfo == null) {
            this.setTargetBrokerEBSVolumeInfo(new ArrayList<BrokerEBSVolumeInfo>(targetBrokerEBSVolumeInfo.length));
        }
        for (BrokerEBSVolumeInfo ele : targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo.add(ele);
        }
        return this;
    }

    public UpdateBrokerStorageRequest withTargetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo) {
        this.setTargetBrokerEBSVolumeInfo(targetBrokerEBSVolumeInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getCurrentVersion() != null) {
            sb.append("CurrentVersion: ").append(this.getCurrentVersion()).append(",");
        }
        if (this.getTargetBrokerEBSVolumeInfo() != null) {
            sb.append("TargetBrokerEBSVolumeInfo: ").append(this.getTargetBrokerEBSVolumeInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerStorageRequest)) {
            return false;
        }
        UpdateBrokerStorageRequest other = (UpdateBrokerStorageRequest)obj;
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getCurrentVersion() == null ^ this.getCurrentVersion() == null) {
            return false;
        }
        if (other.getCurrentVersion() != null && !other.getCurrentVersion().equals(this.getCurrentVersion())) {
            return false;
        }
        if (other.getTargetBrokerEBSVolumeInfo() == null ^ this.getTargetBrokerEBSVolumeInfo() == null) {
            return false;
        }
        return other.getTargetBrokerEBSVolumeInfo() == null || other.getTargetBrokerEBSVolumeInfo().equals(this.getTargetBrokerEBSVolumeInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentVersion() == null ? 0 : this.getCurrentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBrokerEBSVolumeInfo() == null ? 0 : this.getTargetBrokerEBSVolumeInfo().hashCode());
        return hashCode;
    }

    public UpdateBrokerStorageRequest clone() {
        return (UpdateBrokerStorageRequest)super.clone();
    }
}

