/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * 
 <p>
 * Information about the broker access configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ConnectivityInfo" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ConnectivityInfo implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Public access control for brokers.
     * </p>
     */
    private PublicAccess publicAccess;
    /**
     * <p>
     * VPC connectivity access control for brokers.
     * </p>
     */
    private VpcConnectivity vpcConnectivity;

    /**
     * <p>
     * Public access control for brokers.
     * </p>
     * 
     * @param publicAccess
     *        <p>
     *        Public access control for brokers.
     *        </p>
     */

    public void setPublicAccess(PublicAccess publicAccess) {
        this.publicAccess = publicAccess;
    }

    /**
     * <p>
     * Public access control for brokers.
     * </p>
     * 
     * @return <p>
     *         Public access control for brokers.
     *         </p>
     */

    public PublicAccess getPublicAccess() {
        return this.publicAccess;
    }

    /**
     * <p>
     * Public access control for brokers.
     * </p>
     * 
     * @param publicAccess
     *        <p>
     *        Public access control for brokers.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConnectivityInfo withPublicAccess(PublicAccess publicAccess) {
        setPublicAccess(publicAccess);
        return this;
    }

    /**
     * <p>
     * VPC connectivity access control for brokers.
     * </p>
     * 
     * @param vpcConnectivity
     *        <p>
     *        VPC connectivity access control for brokers.
     *        </p>
     */

    public void setVpcConnectivity(VpcConnectivity vpcConnectivity) {
        this.vpcConnectivity = vpcConnectivity;
    }

    /**
     * <p>
     * VPC connectivity access control for brokers.
     * </p>
     * 
     * @return <p>
     *         VPC connectivity access control for brokers.
     *         </p>
     */

    public VpcConnectivity getVpcConnectivity() {
        return this.vpcConnectivity;
    }

    /**
     * <p>
     * VPC connectivity access control for brokers.
     * </p>
     * 
     * @param vpcConnectivity
     *        <p>
     *        VPC connectivity access control for brokers.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConnectivityInfo withVpcConnectivity(VpcConnectivity vpcConnectivity) {
        setVpcConnectivity(vpcConnectivity);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPublicAccess() != null)
            sb.append("PublicAccess: ").append(getPublicAccess()).append(",");
        if (getVpcConnectivity() != null)
            sb.append("VpcConnectivity: ").append(getVpcConnectivity());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ConnectivityInfo == false)
            return false;
        ConnectivityInfo other = (ConnectivityInfo) obj;
        if (other.getPublicAccess() == null ^ this.getPublicAccess() == null)
            return false;
        if (other.getPublicAccess() != null && other.getPublicAccess().equals(this.getPublicAccess()) == false)
            return false;
        if (other.getVpcConnectivity() == null ^ this.getVpcConnectivity() == null)
            return false;
        if (other.getVpcConnectivity() != null && other.getVpcConnectivity().equals(this.getVpcConnectivity()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPublicAccess() == null) ? 0 : getPublicAccess().hashCode());
        hashCode = prime * hashCode + ((getVpcConnectivity() == null) ? 0 : getVpcConnectivity().hashCode());
        return hashCode;
    }

    @Override
    public ConnectivityInfo clone() {
        try {
            return (ConnectivityInfo) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kafka.model.transform.ConnectivityInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
