/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.services.kafka.model.Configuration;
import com.amazonaws.services.kafka.model.transform.ConfigurationRevisionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ConfigurationJsonUnmarshaller
implements Unmarshaller<Configuration, JsonUnmarshallerContext> {
    private static ConfigurationJsonUnmarshaller instance;

    public Configuration unmarshall(JsonUnmarshallerContext context) throws Exception {
        Configuration configuration = new Configuration();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    configuration.setArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    configuration.setCreationTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    configuration.setDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("kafkaVersions", targetDepth)) {
                    context.nextToken();
                    configuration.setKafkaVersions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("latestRevision", targetDepth)) {
                    context.nextToken();
                    configuration.setLatestRevision(ConfigurationRevisionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    configuration.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    configuration.setState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return configuration;
    }

    public static ConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

