/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafkaconnect.model.transform.S3LocationMarshaller;
import java.io.Serializable;

public class S3Location
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketArn;
    private String fileKey;
    private String objectVersion;

    public void setBucketArn(String bucketArn) {
        this.bucketArn = bucketArn;
    }

    public String getBucketArn() {
        return this.bucketArn;
    }

    public S3Location withBucketArn(String bucketArn) {
        this.setBucketArn(bucketArn);
        return this;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public S3Location withFileKey(String fileKey) {
        this.setFileKey(fileKey);
        return this;
    }

    public void setObjectVersion(String objectVersion) {
        this.objectVersion = objectVersion;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    public S3Location withObjectVersion(String objectVersion) {
        this.setObjectVersion(objectVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketArn() != null) {
            sb.append("BucketArn: ").append(this.getBucketArn()).append(",");
        }
        if (this.getFileKey() != null) {
            sb.append("FileKey: ").append(this.getFileKey()).append(",");
        }
        if (this.getObjectVersion() != null) {
            sb.append("ObjectVersion: ").append(this.getObjectVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        if (other.getBucketArn() == null ^ this.getBucketArn() == null) {
            return false;
        }
        if (other.getBucketArn() != null && !other.getBucketArn().equals(this.getBucketArn())) {
            return false;
        }
        if (other.getFileKey() == null ^ this.getFileKey() == null) {
            return false;
        }
        if (other.getFileKey() != null && !other.getFileKey().equals(this.getFileKey())) {
            return false;
        }
        if (other.getObjectVersion() == null ^ this.getObjectVersion() == null) {
            return false;
        }
        return other.getObjectVersion() == null || other.getObjectVersion().equals(this.getObjectVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketArn() == null ? 0 : this.getBucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getFileKey() == null ? 0 : this.getFileKey().hashCode());
        hashCode = 31 * hashCode + (this.getObjectVersion() == null ? 0 : this.getObjectVersion().hashCode());
        return hashCode;
    }

    public S3Location clone() {
        try {
            return (S3Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

