/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.DataSourceSyncJob;
import java.util.Date;

@SdkInternalApi
public class DataSourceSyncJobMarshaller {
    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> DATASOURCEERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceErrorCode").build();
    private static final DataSourceSyncJobMarshaller instance = new DataSourceSyncJobMarshaller();

    public static DataSourceSyncJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSourceSyncJob dataSourceSyncJob, ProtocolMarshaller protocolMarshaller) {
        if (dataSourceSyncJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getExecutionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)dataSourceSyncJob.getDataSourceErrorCode(), DATASOURCEERRORCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

