/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.TableRow;
import com.amazonaws.services.kendra.model.transform.TableExcerptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableExcerpt
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TableRow> rows;
    private Integer totalNumberOfRows;

    public List<TableRow> getRows() {
        return this.rows;
    }

    public void setRows(Collection<TableRow> rows) {
        if (rows == null) {
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<TableRow>(rows);
    }

    public TableExcerpt withRows(TableRow ... rows) {
        if (this.rows == null) {
            this.setRows(new ArrayList<TableRow>(rows.length));
        }
        for (TableRow ele : rows) {
            this.rows.add(ele);
        }
        return this;
    }

    public TableExcerpt withRows(Collection<TableRow> rows) {
        this.setRows(rows);
        return this;
    }

    public void setTotalNumberOfRows(Integer totalNumberOfRows) {
        this.totalNumberOfRows = totalNumberOfRows;
    }

    public Integer getTotalNumberOfRows() {
        return this.totalNumberOfRows;
    }

    public TableExcerpt withTotalNumberOfRows(Integer totalNumberOfRows) {
        this.setTotalNumberOfRows(totalNumberOfRows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRows() != null) {
            sb.append("Rows: ").append(this.getRows()).append(",");
        }
        if (this.getTotalNumberOfRows() != null) {
            sb.append("TotalNumberOfRows: ").append(this.getTotalNumberOfRows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableExcerpt)) {
            return false;
        }
        TableExcerpt other = (TableExcerpt)obj;
        if (other.getRows() == null ^ this.getRows() == null) {
            return false;
        }
        if (other.getRows() != null && !other.getRows().equals(this.getRows())) {
            return false;
        }
        if (other.getTotalNumberOfRows() == null ^ this.getTotalNumberOfRows() == null) {
            return false;
        }
        return other.getTotalNumberOfRows() == null || other.getTotalNumberOfRows().equals(this.getTotalNumberOfRows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRows() == null ? 0 : this.getRows().hashCode());
        hashCode = 31 * hashCode + (this.getTotalNumberOfRows() == null ? 0 : this.getTotalNumberOfRows().hashCode());
        return hashCode;
    }

    public TableExcerpt clone() {
        try {
            return (TableExcerpt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableExcerptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

